<?php

/**
 * Template part for displaying Page Header
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package agrion
 */
?>
<!--Page Header Start-->
<section class="page-header">
	<div class="page-header-bg"></div>
	<div class="container">
		<div class="page-header__inner">
			<?php $agrion_page_meta_breadcumb_status = empty(get_post_meta(get_the_ID(), 'agrion_show_page_breadcrumb', true)) ? 'on' : get_post_meta(get_the_ID(), 'agrion_show_page_breadcrumb', true); ?>
			<?php if (function_exists('bcn_display') && 'yes' == get_theme_mod('breadcrumb_opt', 'off') && 'on' == $agrion_page_meta_breadcumb_status) : ?>
				<ul class="thm-breadcrumb list-unstyled ml-0" typeof="BreadcrumbList" vocab="https://schema.org/">
					<?php bcn_display_list(); ?>
				</ul>
			<?php endif; ?>
			<?php
			$agrion_page_title_text = !empty(get_post_meta(get_the_ID(), 'agrion_set_header_title', true)) ? get_post_meta(get_the_ID(), 'agrion_set_header_title', true) : get_the_title();
			$agrion_page_header_tag = apply_filters('agrion_page_header_tag', 'h2');
			?>

			<<?php echo esc_attr($agrion_page_header_tag); ?>>
				<?php if (!is_page()) : ?>
					<?php agrion_page_title(); ?>
				<?php else : ?>
					<?php echo wp_kses($agrion_page_title_text, 'agrion_allowed_tags') ?>
				<?php endif; ?>
			</<?php echo esc_attr($agrion_page_header_tag); ?>>

		</div>
	</div>
</section>
<!--Page Header End-->