<?php

/**
 * Template part for displaying footer
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package agrion
 */
?>


<?php
$agrion_page_id     = get_queried_object_id();
$agrion_custom_footer_status = !empty(get_post_meta($agrion_page_id, 'agrion_custom_footer_status', true)) ? get_post_meta($agrion_page_id, 'agrion_custom_footer_status', true) : 'off';

$agrion_custom_footer_id = '';
if ((is_page() && 'on' === $agrion_custom_footer_status) || (is_singular('portfolio') && 'on' === $agrion_custom_footer_status) || (is_singular('service') && 'on' === $agrion_custom_footer_status) || (is_singular('team') && 'on' === $agrion_custom_footer_status)) {
    $agrion_custom_footer_id = get_post_meta($agrion_page_id, 'agrion_select_custom_footer', true);
} elseif ('yes' == get_theme_mod('footer_custom')) {
    $agrion_custom_footer_id = get_theme_mod('footer_custom_post');
} else {
    $agrion_custom_footer_id = 'default_footer';
}

$agrion_dynamic_footer = isset($_GET['custom_footer_id']) ? $_GET['custom_footer_id'] : $agrion_custom_footer_id;
?>


<?php if ('default_footer' == $agrion_dynamic_footer) : ?>
    <footer class="footer-one default-footer">
        <div class="footer-one__bottom">
            <div class="container">
                <div class="row">
                    <div class="col-xl-12">
                        <div class="footer-one__bottom-inner-default text-center">
                            <div class="footer-one__bottom-text">
                                <p><?php echo wp_kses(get_theme_mod('footer_copytext', esc_html__('&copy; Copyright 2023 by Agrion', 'agrion')), 'agrion_allowed_tags'); ?></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </footer>
<?php else : ?>
    <?php echo do_shortcode('[agrion-footer id="' . $agrion_dynamic_footer . '"]');
    ?>
<?php endif; ?>