<?php

/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package agrion
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

	<?php agrion_post_thumbnail(); ?>

	<div class="blog-details__content clearfix">
		<ul class="list-unstyled blog-details__meta ml-0">
			<li><?php agrion_posted_on(); ?></li>
			<li><?php agrion_posted_by(); ?></li>
			<?php if (!is_single() && !post_password_required() && (comments_open() || get_comments_number())) : ?>
				<li><?php agrion_comment_count(); ?></li>
			<?php endif; ?>
		</ul>

		<?php
		the_content(
			sprintf(
				wp_kses(
					/* translators: %s: Name of current post. Only visible to screen readers */
					__('Continue reading<span class="screen-reader-text"> "%s"</span>', 'agrion'),
					array(
						'span' => array(
							'class' => array(),
						),
					)
				),
				wp_kses_post(get_the_title())
			)
		);

		wp_link_pages(
			array(
				'before' => '<div class="page-links">' . esc_html__('Pages:', 'agrion'),
				'after'  => '</div>',
			)
		);
		?>
	</div>
	<div class="blog-details__bottom">
		<?php agrion_entry_footer(); ?>
	</div>

</article><!-- #post-<?php the_ID(); ?> -->