<?php

/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package agrion
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class('blog-sidebar__content'); ?>>

	<div class="blog-sidebar__single">

		<?php agrion_post_thumbnail(); ?>

		<div class="blog-sidebar__content-box">
			<ul class="list-unstyled blog-sidebar__meta ml-0">
				<li><?php agrion_posted_on(); ?></li>
				<li><?php agrion_posted_by(); ?></li>
				<?php if (!is_single() && !post_password_required() && (comments_open() || get_comments_number())) : ?>
					<li><?php agrion_comment_count(); ?></li>
				<?php endif; ?>
			</ul>
			<h3 class="blog-sidebar__title">
				<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
			</h3>
			<?php $agrion_excerpt_count = apply_filters('agrion_excerpt_count', 39); ?>
			<p class="blog-sidebar__text"><?php agrion_excerpt($agrion_excerpt_count); ?></p>
			<div class="blog-sidebar__bottom">
				<a href="<?php the_permalink(); ?>" class="blog-sidebar__read-more"><?php esc_html_e('Read More', 'agrion'); ?></a>
				<a href="<?php the_permalink(); ?>" class="blog-sidebar__arrow"><span class="icon-right-arrow"></span></a>
			</div>
		</div>
	</div>


</article><!-- #post-<?php the_ID(); ?> -->