<?php

/**
 * agrion functions for getting inline styles from theme customizer
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package agrion
 */

if (!function_exists('agrion_theme_customizer_styles')) :
	function agrion_theme_customizer_styles()
	{

		// agrion color option

		$agrion_inline_style = '';
		$agrion_inline_style .= ':root {
			--agrion-primary: ' . get_theme_mod('theme_primary_color', sanitize_hex_color('#ffcd1e')) . ';
			--agrion-primary-rgb: ' . agrion_hex_to_rgb(get_theme_mod('theme_primary_color', sanitize_hex_color('#ffcd1e'))) . ';
			
			--agrion-base: ' . get_theme_mod('theme_base_color', sanitize_hex_color('#1f6306')) . ';
			--agrion-base-rgb: ' . agrion_hex_to_rgb(get_theme_mod('theme_base_color', sanitize_hex_color('#1f6306'))) . ';

			--agrion-black: ' . get_theme_mod('theme_black_color', sanitize_hex_color('#0e2207')) . ';
			--agrion-black-rgb: ' . agrion_hex_to_rgb(get_theme_mod('theme_black_color', sanitize_hex_color('#0e2207'))) . ';
		}';

		$agrion_inner_banner_bg = get_theme_mod('page_header_bg_image');
		$agrion_inline_style .= '.page-header-bg { background-image: url(' . $agrion_inner_banner_bg . '); } ';

		$agrion_preloader_icon = get_theme_mod('preloader_image');
		if ($agrion_preloader_icon) {
			$agrion_inline_style .= '.preloader .preloader__image { background-image: url(' . $agrion_preloader_icon . '); } ';
		}

		if (is_page()) {


			$agrion_page_primary_color = empty(get_post_meta(get_the_ID(), 'agrion_primary_color', true)) ? get_theme_mod('theme_primary_color', sanitize_hex_color('#ffcd1e')) : get_post_meta(get_the_ID(), 'agrion_primary_color', true);

			$agrion_page_base_color = empty(get_post_meta(get_the_ID(), 'agrion_base_color', true)) ? get_theme_mod('theme_base_color', sanitize_hex_color('#1f6306')) : get_post_meta(get_the_ID(), 'agrion_base_color', true);

			$agrion_page_black_color = empty(get_post_meta(get_the_ID(), 'agrion_black_color', true)) ? get_theme_mod('theme_black_color', sanitize_hex_color('#0e2207')) : get_post_meta(get_the_ID(), 'agrion_black_color', true);

			$agrion_inline_style .= ':root {
				--agrion-primary: ' . $agrion_page_primary_color . ';
				--agrion-primary-rgb: ' . agrion_hex_to_rgb($agrion_page_primary_color) . ';
				--agrion-base: ' . $agrion_page_base_color . ';
				--agrion-base-rgb: ' . agrion_hex_to_rgb($agrion_page_base_color) . ';
				--agrion-black: ' . $agrion_page_black_color . ';
				--agrion-black-rgb: ' . agrion_hex_to_rgb($agrion_page_black_color) . ';
			}';

			$agrion_page_header_bg = empty(get_post_meta(get_the_ID(), 'agrion_set_header_image', true)) ? get_theme_mod('page_header_bg_image') : get_post_meta(get_the_ID(), 'agrion_set_header_image', true);

			$agrion_inline_style .= '.page-header-bg { background-image: url(' . $agrion_page_header_bg . '); }';
		}

		if (is_singular('post')) {
			$agrion_post_header_bg = empty(get_post_meta(get_the_ID(), 'agrion_set_header_image', true)) ? get_theme_mod('page_header_bg_image') : get_post_meta(get_the_ID(), 'agrion_set_header_image', true);

			$agrion_inline_style .= '.page-header-bg  { background-image: url(' . $agrion_post_header_bg . '); }';
		}


		wp_add_inline_style('agrion-style', $agrion_inline_style);
	}
endif;

add_action('wp_enqueue_scripts', 'agrion_theme_customizer_styles');
