<?php

namespace Layerdrops\Agrion\Widgets;


class Video extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'agrion-video';
    }

    public function get_title()
    {
        return __('Video', 'agrion-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['agrion-category'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'agrion-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'agrion-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'agrion-addon'),
                    'layout_two' => __('Layout Two', 'agrion-addon'),
                ]
            ]
        );

        $this->end_controls_section();

        include agrion_get_elementor_option('video-one-option.php');
        include agrion_get_elementor_option('video-two-option.php');

        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Content Style', 'agrion-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        agrion_elementor_general_style_options($this, 'Title', '{{WRAPPER}} .video-one__inner .video-one__video-title', ['layout_one', 'layout_two']);

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include agrion_get_template('video-one.php');
        include agrion_get_template('video-two.php');
    }
}
