<?php

namespace Layerdrops\Agrion\Widgets;


class Testimonials extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'agrion-testimonials';
    }

    public function get_title()
    {
        return __('Testimonials', 'agrion-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['agrion-category'];
    }

    protected function register_controls()
    {


        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'agrion-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'agrion-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'agrion-addon'),
                    'layout_two' => __('Layout Two', 'agrion-addon'),
                    'layout_three' => __('Layout Three', 'agrion-addon'),
                    'layout_four' => __('Layout Four', 'agrion-addon'),
                    'layout_five' => __('Layout Five', 'agrion-addon'),
                ]
            ]
        );


        $this->end_controls_section();


        include agrion_get_elementor_option('testimonial-one-option.php');
        include agrion_get_elementor_option('testimonial-two-option.php');
        include agrion_get_elementor_option('testimonial-three-option.php');
        include agrion_get_elementor_option('testimonial-four-option.php');
        include agrion_get_elementor_option('testimonial-five-option.php');

        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Content Style', 'agrion-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        agrion_elementor_general_style_options($this, 'Section Title', '{{WRAPPER}} .section-title__title', ['layout_one', 'layout_two', 'layout_three']);
        agrion_elementor_general_style_options($this, 'Section Sub Title', '{{WRAPPER}} .section-title__tagline', ['layout_one', 'layout_two', 'layout_three']);

        agrion_elementor_general_style_options($this, 'Name', '{{WRAPPER}} .testimonial-one__client-name,{{WRAPPER}} .testimonial-two__client-text', ['layout_one', 'layout_two', 'layout_three', 'layout_four', 'layout_five']);
        agrion_elementor_general_style_options($this, 'Designation', '{{WRAPPER}} .testimonial-one__client-sub-title,{{WRAPPER}} .testimonial-two__client-text span', ['layout_one', 'layout_two', 'layout_three', 'layout_four', 'layout_five']);
        agrion_elementor_general_style_options($this, 'Content', '{{WRAPPER}} .testimonial-one__text,{{WRAPPER}} .testimonial-two__text', ['layout_one', 'layout_two', 'layout_three', 'layout_four', 'layout_five']);

        agrion_elementor_general_style_options($this, 'Features Title', '{{WRAPPER}} .testimonial-two__counter-text', ['layout_two']);
        agrion_elementor_general_style_options($this, 'Count Number', '{{WRAPPER}} .testimonial-two__counter-count-box h3,{{WRAPPER}} .counter-one__plus', ['layout_two']);
        $this->end_controls_section();

        agrion_get_elementor_carousel_options($this, ['layout_one', 'layout_three', 'layout_five']);
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include agrion_get_template('testimonials-one.php');
        include agrion_get_template('testimonials-two.php');
        include agrion_get_template('testimonials-three.php');
        include agrion_get_template('testimonials-four.php');
        include agrion_get_template('testimonials-five.php');
    }
}
