<?php

namespace Layerdrops\Agrion\Widgets;


class Team extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'agrion-team';
    }

    public function get_title()
    {
        return __('Team', 'agrion-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['agrion-category'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'agrion-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'agrion-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'agrion-addon'),
                    'layout_two' => __('Layout Two', 'agrion-addon'),
                    'layout_three' => __('Layout Three', 'agrion-addon'),
                ]
            ]
        );

        $this->end_controls_section();

        include agrion_get_elementor_option('team-one-option.php');
        include agrion_get_elementor_option('team-two-option.php');
        include agrion_get_elementor_option('team-three-option.php');

        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Content Style', 'agrion-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        agrion_elementor_general_style_options($this, 'Section Title', '{{WRAPPER}} .section-title__title', ['layout_one']);
        agrion_elementor_general_style_options($this, 'Section Sub Title', '{{WRAPPER}} .section-title__tagline', ['layout_one']);

        agrion_elementor_general_style_options($this, 'Name', '{{WRAPPER}} .team-one__title a', ['layout_one', 'layout_two', 'layout_three']);
        agrion_elementor_general_style_options($this, 'Designation', '{{WRAPPER}} .team-one__subtitle', ['layout_one', 'layout_two', 'layout_three']);

        $this->end_controls_section();

        agrion_get_elementor_carousel_options($this,  'layout_three');
        agrion_elementor_column_count_options($this, ['layout_one', 'layout_two']);
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include agrion_get_template('team-one.php');
        include agrion_get_template('team-two.php');
        include agrion_get_template('team-three.php');
    }
}
