<?php

namespace Layerdrops\Agrion\Widgets;


class SideBar extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'agrion-sidebar';
    }

    public function get_title()
    {
        return __('Sidebar', 'agrion-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['agrion-category'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'agrion-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'agrion-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'agrion-addon'),
                    'layout_two' => __('Layout Two', 'agrion-addon'),
                    'layout_three' => __('Layout Three', 'agrion-addon'),
                    'layout_four' => __('Layout Four', 'agrion-addon'),
                ]
            ]
        );


        $this->end_controls_section();

        include agrion_get_elementor_option('sidebar-one-option.php');
        include agrion_get_elementor_option('sidebar-two-option.php');
        include agrion_get_elementor_option('sidebar-three-option.php');
        include agrion_get_elementor_option('sidebar-four-option.php');


        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Content Style', 'agrion-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        agrion_elementor_general_style_options($this, 'Title', '{{WRAPPER}} .sidebar__title,{{WRAPPER}} .services-details__need-help-title,{{WRAPPER}} .project-details__quote-title', ['layout_one', 'layout_two', 'layout_four']);
        agrion_elementor_general_style_options($this, 'Nav', '{{WRAPPER}} .sidebar__single ul li a', ['layout_one']);

        agrion_elementor_general_style_options($this, 'Call Text', '{{WRAPPER}} .services-details__need-help-contact p', ['layout_two']);
        agrion_elementor_general_style_options($this, 'Call Number', '{{WRAPPER}} .services-details__need-help-contact a', ['layout_two']);

        agrion_elementor_general_style_options($this, 'Info Title', '{{WRAPPER}} .project-details__client', ['layout_three']);
        agrion_elementor_general_style_options($this, 'Info Text', '{{WRAPPER}} .project-details__name', ['layout_three']);
        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        include agrion_get_template('sidebar-one.php');
        include agrion_get_template('sidebar-two.php');
        include agrion_get_template('sidebar-three.php');
        include agrion_get_template('sidebar-four.php');
    }
}
