<?php

namespace Layerdrops\Agrion\Widgets;


class Shop extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'agrion-shop';
    }

    public function get_title()
    {
        return __('Shop', 'agrion-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['agrion-category'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'agrion-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'agrion-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'agrion-addon'),
                    'layout_two' => __('Layout Two', 'agrion-addon'),
                ]
            ]
        );

        $this->end_controls_section();

        include  agrion_get_elementor_option('woo-option.php');

        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Content Style', 'agrion-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        agrion_elementor_general_style_options($this, 'Section Title', '{{WRAPPER}} .section-title__title', ['layout_one', 'layout_two']);
        agrion_elementor_general_style_options($this, 'Section Sub Title', '{{WRAPPER}} .section-title__tagline', ['layout_one', 'layout_two']);

        agrion_elementor_general_style_options($this, 'Product Title', '{{WRAPPER}} .new-product__title a', ['layout_one', 'layout_two']);
        agrion_elementor_general_style_options($this, 'Product Price', '{{WRAPPER}} .new-product__price', ['layout_one', 'layout_two']);

        $this->end_controls_section();

        agrion_elementor_column_count_options($this, ['layout_one']);
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include agrion_get_template('shop-one.php');
        include agrion_get_template('shop-two.php');
    }
}
