<?php

namespace Layerdrops\Agrion\Widgets;


class Shape extends \Elementor\Widget_Base
{
	public function get_name()
	{
		return 'agrion-shape';
	}

	public function get_title()
	{
		return __('Shape', 'agrion-addon');
	}

	public function get_icon()
	{
		return 'eicon-cogs';
	}

	public function get_categories()
	{
		return ['agrion-category'];
	}

	protected function register_controls()
	{
		$this->start_controls_section(
			'layout_section',
			[
				'label' => __('Layout', 'agrion-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'layout_type',
			[
				'label' => __('Select Layout', 'agrion-addon'),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'default' => 'layout_one',
				'options' => [
					'layout_one' => __('Layout One', 'agrion-addon'),
					'layout_two' => __('Layout Two', 'agrion-addon'),
				]
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'layout_one_content_section',
			[
				'label' => __('Content', 'agrion-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
				'condition' => [
					'layout_type' => ['layout_one', 'layout_two']
				]
			]
		);

		$this->add_control(
			'shape',
			[
				'label' => __('Shape', 'agrion-addon'),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [],
			]
		);


		$this->end_controls_section();
	}

	protected function render()
	{
		$settings = $this->get_settings_for_display();
		include agrion_get_template('shape-one.php');
		include agrion_get_template('shape-two.php');
	}
}
