<?php

namespace Layerdrops\Agrion\Widgets;


class Service extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'agrion-service';
    }

    public function get_title()
    {
        return __('Service', 'agrion-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['agrion-category'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'agrion-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'agrion-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'agrion-addon'),
                    'layout_two' => __('Layout Two', 'agrion-addon'),
                    'layout_three' => __('Layout Three', 'agrion-addon'),
                    'layout_four' => __('Layout Four', 'agrion-addon'),
                ]
            ]
        );


        $this->end_controls_section();

        include agrion_get_elementor_option('service-one-option.php');
        include agrion_get_elementor_option('service-two-option.php');
        include agrion_get_elementor_option('service-three-option.php');
        include agrion_get_elementor_option('service-four-option.php');

        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Content Style', 'agrion-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        agrion_elementor_general_style_options($this, 'Section Title', '{{WRAPPER}} .section-title__title', ['layout_one', 'layout_two']);
        agrion_elementor_general_style_options($this, 'Section Sub Title', '{{WRAPPER}} .section-title__tagline', ['layout_one', 'layout_two']);

        agrion_elementor_general_style_options($this, 'Service Title', '{{WRAPPER}} .services-one__title a,{{WRAPPER}} .services-two__title a,{{WRAPPER}} .services-two__hover-title a', ['layout_one', 'layout_two', 'layout_three', 'layout_four']);
        agrion_elementor_general_style_options($this, 'Service Tag Line', '{{WRAPPER}} p.services-two__subtitle', ['layout_two', 'layout_three']);
        agrion_elementor_general_style_options($this, 'Service Read Text', '{{WRAPPER}} .services-two__more-details a,{{WRAPPER}} .services-two__hover-more-details a', ['layout_two', 'layout_three']);

        agrion_elementor_general_style_options($this, 'Service Text', '{{WRAPPER}} .services-one__content p,{{WRAPPER}} .services-two__hover-text', ['layout_one', 'layout_two', 'layout_three', 'layout_four']);

        $this->end_controls_section();

        agrion_get_elementor_carousel_options($this, ['layout_four']);
        agrion_elementor_column_count_options($this, ['layout_one', 'layout_two']);
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include agrion_get_template('service-one.php');
        include agrion_get_template('service-two.php');
        include agrion_get_template('service-three.php');
        include agrion_get_template('service-four.php');
    }
}
