<?php

namespace Layerdrops\Agrion\Widgets;


class Project extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'agrion-portfolio';
    }

    public function get_title()
    {
        return __('Project', 'agrion-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['agrion-category'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'agrion-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'agrion-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'agrion-addon'),
                    'layout_two' => __('Layout Two', 'agrion-addon'),
                    'layout_three' => __('Layout Three', 'agrion-addon'),
                    'layout_four' => __('Layout Four', 'agrion-addon'),
                    'layout_five' => __('Layout Five', 'agrion-addon'),
                    'layout_six' => __('Layout Six', 'agrion-addon'),
                ]
            ]
        );


        $this->end_controls_section();

        include agrion_get_elementor_option('project-one-option.php');
        include agrion_get_elementor_option('project-two-option.php');
        include agrion_get_elementor_option('project-three-option.php');
        include agrion_get_elementor_option('project-four-option.php');
        include agrion_get_elementor_option('project-five-option.php');
        include agrion_get_elementor_option('project-six-option.php');

        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Content Style', 'agrion-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        agrion_elementor_general_style_options($this, 'Section Title', '{{WRAPPER}} .section-title__title', ['layout_one', 'layout_two', 'layout_six']);
        agrion_elementor_general_style_options($this, 'Section Sub Title', '{{WRAPPER}} .section-title__tagline', ['layout_one', 'layout_two', 'layout_six']);

        agrion_elementor_general_style_options($this, 'Project Title', '{{WRAPPER}} .project-one__title a,{{WRAPPER}}  .project-two__title a', ['layout_one', 'layout_two', 'layout_three', 'layout_four', 'layout_five', 'layout_six']);
        agrion_elementor_general_style_options($this, 'Project Tag Line', '{{WRAPPER}} .project-one__tagline', ['layout_one', 'layout_three', 'layout_five', 'layout_six']);

        $this->end_controls_section();

        //button style
        $this->start_controls_section(
            'button_style',
            [
                'label' => esc_html__('Button Style', 'agrion-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'layout_type' => ['layout_three', 'layout_four']
                ]
            ]
        );

        agrion_elementor_button_style_options($this, 'Button', '{{WRAPPER}} .thm-btn.project-page__btn', '.thm-btn.project-page__btn::before', ['layout_three', 'layout_four']);

        $this->end_controls_section();

        agrion_get_elementor_carousel_options($this, ['layout_two', 'layout_five']);

        agrion_elementor_column_count_options($this, ['layout_one', 'layout_three', 'layout_four', 'layout_six']);
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include agrion_get_template('project-one.php');
        include agrion_get_template('project-two.php');
        include agrion_get_template('project-three.php');
        include agrion_get_template('project-four.php');
        include agrion_get_template('project-five.php');
        include agrion_get_template('project-six.php');
    }
}
