<?php

namespace Layerdrops\Agrion\Widgets;


class MainSlider extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'agrion-main-slider';
    }

    public function get_title()
    {
        return __('Main Slider', 'agrion-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['agrion-category'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'agrion-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'agrion-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'agrion-addon'),
                    'layout_two' => __('Layout Two', 'agrion-addon'),
                    'layout_three' => __('Layout Three', 'agrion-addon'),
                ]
            ]
        );


        $this->end_controls_section();

        include agrion_get_elementor_option('main-slider-one-option.php');
        include agrion_get_elementor_option('main-slider-two-option.php');
        include agrion_get_elementor_option('main-slider-three-option.php');

        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Content Style', 'agrion-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        agrion_elementor_general_style_options($this, 'Title', '{{WRAPPER}} .main-slider__title, {{WRAPPER}} .main-slider-two__title', ['layout_one', 'layout_two']);
        agrion_elementor_general_style_options($this, 'Sub Title', '{{WRAPPER}} .main-slider__sub-title, {{WRAPPER}} .main-slider-two__sub-title', ['layout_one', 'layout_two']);

        $this->end_controls_section();

        //button style
        $this->start_controls_section(
            'button_style',
            [
                'label' => esc_html__('Button Style', 'agrion-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        agrion_elementor_button_style_options($this, 'Button', '{{WRAPPER}} .thm-btn.main-slider__btn,{{WRAPPER}} a.thm-btn', '{{WRAPPER}} .main-slider__btn:before,{{WRAPPER}} .main-slider-two__btn:before', ['layout_one', 'layout_two']);

        $this->end_controls_section();

        agrion_get_elementor_carousel_options($this, ['layout_one', 'layout_two', 'layout_three']);
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include agrion_get_template('main-slider-one.php');
        include agrion_get_template('main-slider-two.php');
        include agrion_get_template('main-slider-three.php');
    }
}
