<?php

namespace Layerdrops\Agrion\Widgets;


class Header extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'agrion-header';
    }

    public function get_title()
    {
        return __('Header', 'agrion-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['agrion-category'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout Type', 'agrion-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'agrion-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'agrion-addon'),
                    'layout_two' => __('Layout Two', 'agrion-addon'),
                    'layout_three' => __('Layout Three', 'agrion-addon'),
                ]
            ]
        );

        $this->end_controls_section();

        include agrion_get_elementor_option('header-option.php');

        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Font Options', 'agrion-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        agrion_elementor_general_style_options($this, 'Menu', '{{WRAPPER}} .main-menu .main-menu__list > li > a', ['layout_one', 'layout_two', 'layout_three']);
        agrion_elementor_general_style_options($this, 'Top bar', '{{WRAPPER}} .main-header__contact-list li .text p, {{WRAPPER}} .main-header__contact-list li .text p a, {{WRAPPER}} .main-header-three__contact li .text p,{{WRAPPER}} .main-header-two__contact-list li .text p,{{WRAPPER}} .main-header-two__contact-list li .text p a', ['layout_one', 'layout_two', 'layout_three']);
        agrion_elementor_button_style_options($this, 'Button', '{{WRAPPER}} .thm-btn', '{{WRAPPER}} .thm-btn:before,{{WRAPPER}} .thm-btn.main-menu__btn:before', ['layout_one', 'layout_two', 'layout_three']);

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include agrion_get_template('header.php');
    }
}
