<?php

namespace Layerdrops\Agrion\Widgets;


class Faq extends \Elementor\Widget_Base
{
	public function get_name()
	{
		return 'agrion-faq';
	}

	public function get_title()
	{
		return __('FAQ', 'agrion-addon');
	}

	public function get_icon()
	{
		return 'eicon-cogs';
	}

	public function get_categories()
	{
		return ['agrion-category'];
	}

	protected function register_controls()
	{

		$this->start_controls_section(
			'layout_section',
			[
				'label' => __('Layout', 'agrion-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'layout_type',
			[
				'label' => __('Select Layout', 'agrion-addon'),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'default' => 'layout_one',
				'options' => [
					'layout_one' => __('Layout One', 'agrion-addon'),
					'layout_two' => __('Layout Two', 'agrion-addon'),
				]
			]
		);

		$this->end_controls_section();

		include agrion_get_elementor_option('faq-one-option.php');
		include agrion_get_elementor_option('faq-two-option.php');

		//General style
		$this->start_controls_section(
			'general_style',
			[
				'label' => esc_html__('Content Style', 'agrion-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		agrion_elementor_general_style_options($this, 'Section Title', '{{WRAPPER}} .section-title__title', ['layout_one']);
		agrion_elementor_general_style_options($this, 'Section Sub Title', '{{WRAPPER}} .section-title__tagline', ['layout_one']);

		agrion_elementor_general_style_options($this, 'Check List', '{{WRAPPER}} .faq-one__text p', 'layout_one');

		agrion_elementor_general_style_options($this, 'Question', '{{WRAPPER}} .faq-one-accrodion .accrodion-title h4', ['layout_one', 'layout_two']);
		agrion_elementor_general_style_options($this, 'Answer', '{{WRAPPER}} .faq-one-accrodion .accrodion-content p', ['layout_one', 'layout_two']);

		$this->end_controls_section();
	}

	protected function render()
	{
		$settings = $this->get_settings_for_display();
		include agrion_get_template('faq-one.php');
		include agrion_get_template('faq-two.php');
	}
}
