<?php

namespace Layerdrops\Agrion\Widgets;


class CallToAction extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'agrion-call-to-action';
    }

    public function get_title()
    {
        return __('Call To Action', 'agrion-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['agrion-category'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'agrion-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'agrion-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'agrion-addon'),
                    'layout_two' => __('Layout Two', 'agrion-addon'),
                    'layout_three' => __('Layout Three', 'agrion-addon')
                ]
            ]
        );


        $this->end_controls_section();

        include agrion_get_elementor_option('call-to-action-one-option.php');
        include agrion_get_elementor_option('call-to-action-two-option.php');
        include agrion_get_elementor_option('call-to-action-three-option.php');

        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Content Style', 'agrion-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        agrion_elementor_general_style_options($this, 'Title', '{{WRAPPER}} .unbeatable-one__title,{{WRAPPER}} .call-one__content,{{WRAPPER}} .cta-one__title', ['layout_one', 'layout_two', 'layout_three']);
        agrion_elementor_general_style_options($this, 'Sub Title', '{{WRAPPER}} .unbeatable-one__tagline', ['layout_one']);

        agrion_elementor_general_style_options($this, 'Text', '{{WRAPPER}} .call-one__contact-info p', ['layout_two']);
        agrion_elementor_general_style_options($this, 'Phone Number', '{{WRAPPER}} .call-one__contact-info a', ['layout_two']);
        $this->end_controls_section();

        //button style
        $this->start_controls_section(
            'button_style',
            [
                'label' => esc_html__('Button Style', 'agrion-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'layout_type' => ['layout_one', 'layout_three']
                ]
            ]
        );

        agrion_elementor_button_style_options($this, 'Button', '{{WRAPPER}} .thm-btn', '{{WRAPPER}} .thm-btn:before', ['layout_one', 'layout_three']);

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include agrion_get_template('call-to-action-one.php');
        include agrion_get_template('call-to-action-two.php');
        include agrion_get_template('call-to-action-three.php');
    }
}
