<?php

namespace Layerdrops\Agrion\Widgets;


class Blog extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'agrion-blog';
    }

    public function get_title()
    {
        return __('Blog', 'agrion-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['agrion-category'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'agrion-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'agrion-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'agrion-addon'),
                    'layout_two' => __('Layout Two', 'agrion-addon'),
                    'layout_three' => __('Layout Three', 'agrion-addon'),
                    'layout_four' => __('Layout Four', 'agrion-addon'),
                    'layout_five' => __('Layout Five', 'agrion-addon'),
                ]
            ]
        );

        $this->end_controls_section();

        include  agrion_get_elementor_option('blog-option.php');

        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Content Style', 'agrion-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        agrion_elementor_general_style_options($this, 'Section Title', '{{WRAPPER}} .section-title__title', ['layout_one', 'layout_two', 'layout_three']);
        agrion_elementor_general_style_options($this, 'Section Sub Title', '{{WRAPPER}} .section-title__tagline', ['layout_one', 'layout_two', 'layout_three']);

        agrion_elementor_general_style_options($this, 'Post Title', '{{WRAPPER}} .blog-one__title a', ['layout_one', 'layout_two', 'layout_three', 'layout_four', 'layout_five']);
        agrion_elementor_general_style_options($this, 'Post Meta', '{{WRAPPER}} .blog-one__meta li a', ['layout_one', 'layout_two', 'layout_three', 'layout_four', 'layout_five']);

        agrion_elementor_general_style_options($this, 'Post Date', '{{WRAPPER}} .blog-one__date span', ['layout_one', 'layout_two', 'layout_three', 'layout_four', 'layout_five']);
        agrion_elementor_general_style_options($this, 'Post Month', '{{WRAPPER}} .blog-one__date p', ['layout_one', 'layout_two', 'layout_three', 'layout_four', 'layout_five']);

        $this->end_controls_section();

        agrion_get_elementor_carousel_options($this, 'layout_five');

        agrion_elementor_column_count_options($this, ['layout_one', 'layout_two', 'layout_three', 'layout_four']);
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include agrion_get_template('blog-one.php');
        include agrion_get_template('blog-two.php');
        include agrion_get_template('blog-three.php');
        include agrion_get_template('blog-four.php');
        include agrion_get_template('blog-five.php');
    }
}
