<?php

namespace Layerdrops\Agrion\Widgets;


class About extends \Elementor\Widget_Base
{
	public function get_name()
	{
		return 'agrion-about';
	}

	public function get_title()
	{
		return __('About', 'agrion-addon');
	}

	public function get_icon()
	{
		return 'eicon-cogs';
	}

	public function get_categories()
	{
		return ['agrion-category'];
	}

	protected function register_controls()
	{
		$this->start_controls_section(
			'layout_section',
			[
				'label' => __('Layout', 'agrion-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'layout_type',
			[
				'label' => __('Select Layout', 'agrion-addon'),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'default' => 'layout_one',
				'options' => [
					'layout_one' => __('Layout One', 'agrion-addon'),
					'layout_two' => __('Layout Two', 'agrion-addon'),
					'layout_three' => __('Layout Three', 'agrion-addon'),
					'layout_four' => __('Layout Four', 'agrion-addon'),
					'layout_five' => __('Layout Five', 'agrion-addon'),
					'layout_six' => __('Layout Six', 'agrion-addon'),
					'layout_seven' => __('Layout Seven', 'agrion-addon'),
				]
			]
		);

		$this->end_controls_section();

		include agrion_get_elementor_option('about-one-option.php');
		include agrion_get_elementor_option('about-two-option.php');
		include agrion_get_elementor_option('about-three-option.php');
		include agrion_get_elementor_option('about-four-option.php');
		include agrion_get_elementor_option('about-five-option.php');
		include agrion_get_elementor_option('about-six-option.php');
		include agrion_get_elementor_option('about-seven-option.php');

		//General style
		$this->start_controls_section(
			'general_style',
			[
				'label' => esc_html__('Content Style', 'agrion-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		agrion_elementor_general_style_options($this, 'Section Title', '{{WRAPPER}} .section-title__title', ['layout_one', 'layout_two', 'layout_three', 'layout_four', 'layout_five', 'layout_six', 'layout_seven']);
		agrion_elementor_general_style_options($this, 'Section Sub Title', '{{WRAPPER}} .section-title__tagline', ['layout_one', 'layout_two', 'layout_three', 'layout_four', 'layout_five', 'layout_six', 'layout_seven']);

		agrion_elementor_general_style_options($this, 'Highlighted Text', '{{WRAPPER}} .about-one__text-1', 'layout_one');
		agrion_elementor_general_style_options($this, 'Summary Text', '{{WRAPPER}} .about-one__text-2, {{WRAPPER}} .healthy-food-one__text, {{WRAPPER}} .about-two__text, {{WRAPPER}} .Provide-One__text, {{WRAPPER}} .healthy-food-two__left-text,{{WRAPPER}} .organic-only__text, {{WRAPPER}} .about-three__text-1', ['layout_one', 'layout_two', 'layout_three', 'layout_four', 'layout_five', 'layout_six', 'layout_seven']);

		agrion_elementor_general_style_options($this, 'Check List', '{{WRAPPER}} .about-one__points li p,{{WRAPPER}} .healthy-food-two__points-text p', ['layout_one', 'layout_five']);

		agrion_elementor_general_style_options($this, 'Features Title', '{{WRAPPER}} .healthy-food-one__title,{{WRAPPER}} .about-two__title h3,{{WRAPPER}} .Provide-One__progress-content h3,{{WRAPPER}} .organic-only__points-text, {{WRAPPER}} .icon-box-text', ['layout_two', 'layout_three', 'layout_four', 'layout_six', 'layout_seven']);
		agrion_elementor_general_style_options($this, 'Features Text', '{{WRAPPER}} .content p', ['layout_seven']);

		agrion_elementor_general_style_options($this, 'Progress Bar Title', '{{WRAPPER}} .about-three__progress-title', ['layout_seven']);

		agrion_elementor_general_style_options($this, 'Image Caption', '{{WRAPPER}} .about-two__experience-text',  'layout_three', 'layout_four', 'layout_five');
		agrion_elementor_general_style_options($this, 'Count Number', '{{WRAPPER}} .about-two__experience-count-box h3',  'layout_three');

		agrion_elementor_general_style_options($this, 'Author Name', '{{WRAPPER}} .about-one__ceo-name', 'layout_one');
		agrion_elementor_general_style_options($this, 'Author Designation', '{{WRAPPER}} .about-one__ceo-title', 'layout_one');

		$this->end_controls_section();

		//button style
		$this->start_controls_section(
			'button_style',
			[
				'label' => esc_html__('Button Style', 'agrion-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				'condition' => [
					'layout_type' => ['layout_one', 'layout_three', 'layout_five']
				]
			]
		);

		agrion_elementor_button_style_options($this, 'Button', '{{WRAPPER}} .thm-btn', '{{WRAPPER}} .thm-btn:before', ['layout_one', 'layout_three', 'layout_five']);

		$this->end_controls_section();

		agrion_get_circle_options($this, 'layout_four');
	}

	protected function render()
	{
		$settings = $this->get_settings_for_display();

		include agrion_get_template('about-one.php');
		include agrion_get_template('about-two.php');
		include agrion_get_template('about-three.php');
		include agrion_get_template('about-four.php');
		include agrion_get_template('about-five.php');
		include agrion_get_template('about-six.php');
		include agrion_get_template('about-seven.php');
	}
}
