<?php

namespace Layerdrops\Agrion;

class Utility
{
    public function __construct()
    {
        $this->register_image_size();
        add_filter('single_template', [$this, 'load_portfolio_template']);
        add_filter('single_template', [$this, 'load_service_template']);
        add_filter('single_template', [$this, 'load_team_template']);
        add_filter('wpcf7_autop_or_not', '__return_false');
    }
    public function register_image_size()
    {
        add_image_size('agrion_blog_370X410', 370, 410, true); //in use
        add_image_size('agrion_brand_logo_202X102', 202, 102, true); //in use
        add_image_size('agrion_brand_woo_270X308', 270, 308, true); //in use
        add_image_size('agrion_brand_70X70', 70, 70, true); //in use
        add_image_size('agrion_product_268X305', 268, 305, true); //in use

    }

    public function load_portfolio_template($template)
    {
        global $post;

        if ('portfolio' === $post->post_type && locate_template(array('single-portfolio.php')) !== $template) {
            /*
            * This is a 'portfolio' post
            * AND a 'single portfolio template' is not found on
            * theme or child theme directories, so load it
            * from our plugin directory.
            */
            return AGRION_ADDON_PATH . '/post-templates/single-portfolio.php';
        }

        return $template;
    }

    public function load_service_template($template)
    {
        global $post;

        if ('service' === $post->post_type && locate_template(array('single-service.php')) !== $template) {
            /*
            * This is a 'service' post
            * AND a 'single service template' is not found on
            * theme or child theme directories, so load it
            * from our plugin directory.
            */
            return AGRION_ADDON_PATH . '/post-templates/single-service.php';
        }

        return $template;
    }


    public function load_team_template($template)
    {
        global $post;

        if ('team' === $post->post_type && locate_template(array('single-team.php')) !== $template) {
            /*
            * This is a 'team' post
            * AND a 'single team template' is not found on
            * theme or child theme directories, so load it
            * from our plugin directory.
            */
            return AGRION_ADDON_PATH . '/post-templates/single-team.php';
        }

        return $template;
    }
}
