<?php

namespace Layerdrops\Agrion\Metaboxes;


class Page
{
    function __construct()
    {
        add_action('cmb2_admin_init', [$this, 'page_metabox']);
    }

    function page_metabox()
    {
        $prefix = 'agrion_';

        $general = new_cmb2_box(array(
            'id'           => $prefix . 'page_option',
            'title'        => __('General Options', 'agrion-addon'),
            'object_types' => array('page'),
            'context'      => 'normal',
            'priority'     => 'default',
        ));

        $general->add_field(array(
            'name' => __('Enable Custom Header', 'agrion-addon'),
            'id' => $prefix . 'custom_header_status',
            'type' => 'radio',
            'options' => array(
                'on' => __('On', 'agrion-addon'),
                'off'   => __('Off', 'agrion-addon'),
            ),
        ));


        $general->add_field(array(
            'name' => __('Select Custom Header', 'agrion-addon'),
            'id' => $prefix . 'select_custom_header',
            'type' => 'pw_select',
            'options' => agrion_post_query('header'),
            'attributes' => array(
                'data-conditional-id' => $prefix . 'custom_header_status',
                'data-conditional-value' => 'on',
            ),
        ));

        $general->add_field(array(
            'name' => __('Enable Custom Footer', 'agrion-addon'),
            'id' => $prefix . 'custom_footer_status',
            'type' => 'radio',
            'options' => array(
                'on' => __('On', 'agrion-addon'),
                'off'   => __('Off', 'agrion-addon'),
            ),
        ));


        $general->add_field(array(
            'name' => __('Select Custom Footer', 'agrion-addon'),
            'id' => $prefix . 'select_custom_footer',
            'type' => 'pw_select',
            'options' => agrion_post_query('footer'),
            'attributes' => array(
                'data-conditional-id' => $prefix . 'custom_footer_status',
                'data-conditional-value' => 'on',
            ),
        ));


        $general->add_field(array(
            'name' => __('Show Page Banner', 'agrion-addon'),
            'id' => $prefix . 'show_page_banner',
            'type' => 'radio',
            'default' => 'on',
            'options' => array(
                'on' => __('On', 'agrion-addon'),
                'off' => __('Off', 'agrion-addon'),
            ),
        ));

        $general->add_field(array(
            'name' => __('Enable BreadCrumb', 'agrion-addon'),
            'id' => $prefix . 'show_page_breadcrumb',
            'type' => 'radio',
            'default' => 'on',
            'options' => array(
                'on' => __('On', 'agrion-addon'),
                'off' => __('Off', 'agrion-addon'),
            ),
            'attributes' => array(
                'data-conditional-id' => $prefix . 'show_page_banner',
                'data-conditional-value' => 'on',
            ),
        ));


        $general->add_field(array(
            'name' => __('Header Title', 'agrion-addon'),
            'id' => $prefix . 'set_header_title',
            'type' => 'text',
            'attributes' => array(
                'data-conditional-id' => $prefix . 'show_page_banner',
                'data-conditional-value' => 'on',
            ),
        ));

        $general->add_field(array(
            'name' => __('Header Image', 'agrion-addon'),
            'id' => $prefix . 'set_header_image',
            'type' => 'file',
            'attributes' => array(
                'data-conditional-id' => $prefix . 'show_page_banner',
                'data-conditional-value' => 'on',
            ),
        ));

        $color_options = new_cmb2_box(array(
            'id'           => $prefix . 'page_color_option',
            'title'        => __('Color Options', 'agrion-addon'),
            'object_types' => array('page'),
            'context'      => 'normal',
            'priority'     => 'default',
        ));


        $general->add_field(array(
            'name' => __('Enable Dark Mode', 'agrion-addon'),
            'id' => $prefix . 'enable_dark_mode',
            'type' => 'radio',
            'default' => 'no',
            'options' => array(
                'yes' => __('On', 'agrion-addon'),
                'no' => __('Off', 'agrion-addon'),
            ),
        ));

        $general->add_field(array(
            'name' => __('Enable Boxed Mode', 'agrion-addon'),
            'id' => $prefix . 'enable_boxed_mode',
            'type' => 'radio',
            'default' => 'no',
            'options' => array(
                'yes' => __('On', 'agrion-addon'),
                'no' => __('Off', 'agrion-addon'),
            ),
        ));

        $general->add_field(array(
            'name' => __('Enable Rtl Mode', 'agrion-addon'),
            'id' => $prefix . 'enable_rtl_mode',
            'type' => 'radio',
            'default' => 'no',
            'options' => array(
                'yes' => __('On', 'agrion-addon'),
                'no' => __('Off', 'agrion-addon'),
            ),
        ));


        $color_options->add_field(array(
            'name' => __('Base Color', 'agrion-addon'),
            'id' => $prefix . 'base_color',
            'type'    => 'colorpicker',
        ));

        $color_options->add_field(array(
            'name' => __('Primary Color', 'agrion-addon'),
            'id' => $prefix . 'primary_color',
            'type'    => 'colorpicker',
        ));

        $color_options->add_field(array(
            'name' => __('Secondary Color', 'agrion-addon'),
            'id' => $prefix . 'secondary_color',
            'type'    => 'colorpicker',
        ));
    }
}
