<?php

namespace Layerdrops\Agrion;

class Customizer
{
    public function __construct()
    {
        add_action("customize_register", [$this, 'agrion_customizer']);
    }
    public function agrion_customizer($wp_customize)
    {

        // add panel
        $wp_customize->add_panel(
            'agrion_theme_opt',
            array(
                'title'      => esc_html__('Agrion Options', 'agrion-addon'),
                'description' => esc_html__('Agrion Theme options panel', 'agrion-addon'),
                'priority'   => 220,
                'capability' => 'edit_theme_options',
            )
        );

        // General Settings
        $wp_customize->add_section('agrion_theme_general', array(
            'title' => __('General Settings', 'agrion-addon'),
            'description' => esc_html__('Agrion General Settings.', 'agrion-addon'),
            'priority' => 10,
            'capability' => 'edit_theme_options',
            'panel'      => 'agrion_theme_opt'
        ));


        $this->customize_type_color(
            $wp_customize,
            esc_html__('Select Theme Base color', 'agrion-addon'),
            'agrion_theme_general',
            'theme_base_color',
            '#1f6306'
        );

        $this->customize_type_color(
            $wp_customize,
            esc_html__('Select Theme Primary color', 'agrion-addon'),
            'agrion_theme_general',
            'theme_primary_color',
            '#ffcd1e'
        );

        $this->customize_type_color(
            $wp_customize,
            esc_html__('Select Theme Black color', 'agrion-addon'),
            'agrion_theme_general',
            'theme_black_color',
            '#0e2207'
        );


        $this->customize_type_radio(
            $wp_customize,
            esc_html__(' Enable Dark Mode?', 'agrion-addon'),
            'agrion_theme_general',
            'agrion_dark_mode',
            'no',
            array(
                'yes' => esc_html__('Yes', 'agrion-addon'),
                'no' => esc_html__('No', 'agrion-addon'),
            )
        );

        $this->customize_type_radio(
            $wp_customize,
            esc_html__(' Enable Boxed Mode?', 'agrion-addon'),
            'agrion_theme_general',
            'agrion_boxed_mode',
            'no',
            array(
                'yes' => esc_html__('Yes', 'agrion-addon'),
                'no' => esc_html__('No', 'agrion-addon'),
            )
        );

        $this->customize_type_radio(
            $wp_customize,
            esc_html__(' Enable Rtl Mode?', 'agrion-addon'),
            'agrion_theme_general',
            'agrion_rtl_mode',
            'no',
            array(
                'yes' => esc_html__('Yes', 'agrion-addon'),
                'no' => esc_html__('No', 'agrion-addon'),
            )
        );

        $this->customize_type_radio(
            $wp_customize,
            esc_html__(' Enable Custom Cursor', 'agrion-addon'),
            'agrion_theme_general',
            'custom_cursor',
            'yes',
            array(
                'yes' => esc_html__('Yes', 'agrion-addon'),
                'no' => esc_html__('No', 'agrion-addon'),
            )
        );

        $this->customize_type_radio(
            $wp_customize,
            esc_html__(' Enable Back to top?', 'agrion-addon'),
            'agrion_theme_general',
            'scroll_to_top',
            'yes',
            array(
                'yes' => esc_html__('Yes', 'agrion-addon'),
                'no' => esc_html__('No', 'agrion-addon'),
            )
        );

        $this->customize_type_select(
            $wp_customize,
            esc_html__('Select Back to top icon', 'agrion-addon'),
            'agrion_theme_general',
            'scroll_to_top_icon',
            'fa-angle-up',
            agrion_get_fa_icons(),
            function () {
                return (get_theme_mod('scroll_to_top', 'no') == 'yes' ? true : false);
            }
        );

        $this->customize_type_radio(
            $wp_customize,
            esc_html__(' Enable Preloader?', 'agrion-addon'),
            'agrion_theme_general',
            'preloader',
            'yes',
            array(
                'yes' => esc_html__('Yes', 'agrion-addon'),
                'no' => esc_html__('No', 'agrion-addon'),
            )
        );

        $this->customize_type_image(
            $wp_customize,
            esc_html__('Custom Preloader Image', 'agrion-addon'),
            'agrion_theme_general',
            'preloader_image',
            '',
            function () {
                return (get_theme_mod('preloader', 'no') == 'yes' ? true : false);
            }
        );

        $this->customize_type_image(
            $wp_customize,
            esc_html__('Page Header Background Image', 'agrion-addon'),
            'agrion_theme_general',
            'page_header_bg_image'
        );

        // Blog Layout
        $wp_customize->add_section('agrion_blog_layout_settings', array(
            'title' => __('Blog Layout', 'agrion-addon'),
            'description' => esc_html__('Agrion Blog Layout', 'agrion-addon'),
            'priority' => 20,
            'capability' => 'edit_theme_options',
            'panel'      => 'agrion_theme_opt'
        ));

        $this->customize_type_select(
            $wp_customize,
            'Select Sidebar position',
            'agrion_blog_layout_settings',
            'agrion_blog_layout',
            'right-align',
            array(
                'left-align' => esc_html__('Left Align', 'agrion-addon'),
                'right-align' => esc_html__('Right Align', 'agrion-addon'),
            )
        );

        // Header options
        $wp_customize->add_section('agrion_theme_header', array(
            'title' => __('Header Settings', 'agrion-addon'),
            'description' => esc_html__('Agrion Header Settings', 'agrion-addon'),
            'priority' => 20,
            'capability' => 'edit_theme_options',
            'panel'      => 'agrion_theme_opt'
        ));

        $this->customize_type_text(
            $wp_customize,
            esc_html__('Add Logo size in px', 'agrion-addon'),
            'agrion_theme_header',
            'header_logo_width',
            esc_html(198)
        );

        $this->customize_type_radio(
            $wp_customize,
            esc_html__('Enable Sticky Header?', 'agrion-addon'),
            'agrion_theme_header',
            'header_sticky_menu',
            'yes',
            array(
                'yes' => esc_html__('Yes', 'agrion-addon'),
                'no' => esc_html__('No', 'agrion-addon'),
            )
        );

        $this->customize_type_radio(
            $wp_customize,
            esc_html__(' Enable Breadcrumb?', 'agrion-addon'),
            'agrion_theme_header',
            'breadcrumb_opt',
            'yes',
            array(
                'yes' => esc_html__('Yes', 'agrion-addon'),
                'no' => esc_html__('No', 'agrion-addon'),
            )
        );

        $this->customize_type_radio(
            $wp_customize,
            esc_html__('Enable Custom Header?', 'agrion-addon'),
            'agrion_theme_header',
            'header_custom',
            'no',
            array(
                'yes' => esc_html__('Yes', 'agrion-addon'),
                'no' => esc_html__('No', 'agrion-addon'),
            )
        );

        $this->customize_type_select(
            $wp_customize,
            esc_html__('Select Header Type', 'agrion-addon'),
            'agrion_theme_header',
            'header_custom_post',
            '',
            agrion_post_query('header'),
            function () {
                return (get_theme_mod('header_custom', 'no') == 'yes' ? true : false);
            }
        );

        //  Mobile Menu
        $wp_customize->add_section('agrion_theme_mobile_menu', array(
            'title' => esc_html__('Mobile Menu Settings', 'agrion-addon'),
            'description' => esc_html__('Agrion Header Settings', 'agrion-addon'),
            'priority' => 20,
            'capability' => 'edit_theme_options',
            'panel'      => 'agrion_theme_opt'
        ));

        $this->customize_type_text(
            $wp_customize,
            esc_html__('Mobile Menu Email', 'agrion-addon'),
            'agrion_theme_mobile_menu',
            'agrion_mobile_menu_email',
            esc_html__('needhelp@agrion.com', 'agrion-addon')
        );

        $this->customize_type_text(
            $wp_customize,
            esc_html__('Mobile Menu Phone', 'agrion-addon'),
            'agrion_theme_mobile_menu',
            'agrion_mobile_menu_phone',
            esc_html__('666 888 0000', 'agrion-addon')
        );

        $this->customize_type_text(
            $wp_customize,
            esc_html__('Facebook url', 'agrion-addon'),
            'agrion_theme_mobile_menu',
            'facebook_url',
            esc_html('#')
        );

        $this->customize_type_text(
            $wp_customize,
            esc_html__('Twitter url', 'agrion-addon'),
            'agrion_theme_mobile_menu',
            'twitter_url',
            esc_html('#')
        );

        $this->customize_type_text(
            $wp_customize,
            esc_html__('Linkedin url', 'agrion-addon'),
            'agrion_theme_mobile_menu',
            'linkedin_url',
            esc_html('#')
        );

        $this->customize_type_text(
            $wp_customize,
            esc_html__('Pinterest url', 'agrion-addon'),
            'agrion_theme_mobile_menu',
            'pinterest_url',
            esc_html('#')
        );

        $this->customize_type_text(
            $wp_customize,
            esc_html__('Youtube url', 'agrion-addon'),
            'agrion_theme_mobile_menu',
            'youtube_url',
        );


        $this->customize_type_text(
            $wp_customize,
            esc_html__('dribbble url', 'agrion-addon'),
            'agrion_theme_mobile_menu',
            'dribble_url',
        );

        $this->customize_type_text(
            $wp_customize,
            esc_html__('Instagram url', 'agrion-addon'),
            'agrion_theme_mobile_menu',
            'instagram_url',
        );

        $this->customize_type_text(
            $wp_customize,
            esc_html__('Reddit url', 'agrion-addon'),
            'agrion_theme_mobile_menu',
            'reddit_url',
        );

        // Footer options
        $wp_customize->add_section('agrion_theme_footer', array(
            'title' => esc_html__('Footer Settings', 'agrion-addon'),
            'description' => esc_html__('Agrion Footer Settings.', 'agrion-addon'),
            'priority' => 20,
            'capability' => 'edit_theme_options',
            'panel'      => 'agrion_theme_opt'
        ));

        $this->customize_type_text(
            $wp_customize,
            esc_html__('Footer Text', 'agrion-addon'),
            'agrion_theme_footer',
            'footer_copytext',
            esc_html__('&copy; All right reserved', 'agrion'),
            function () {
                return (get_theme_mod('footer_custom', 'no') == 'yes' ? false : true);
            }
        );

        $this->customize_type_radio(
            $wp_customize,
            esc_html__('Enable Custom Footer ?', 'agrion-addon'),
            'agrion_theme_footer',
            'footer_custom',
            'no',
            array(
                'yes' => esc_html__('Yes', 'agrion-addon'),
                'no' => esc_html__('No', 'agrion-addon'),
            )
        );

        $this->customize_type_select(
            $wp_customize,
            esc_html__('Select Footer Type', 'agrion-addon'),
            'agrion_theme_footer',
            'footer_custom_post',
            '',
            agrion_post_query('footer'),
            function () {
                return (get_theme_mod('footer_custom', 'no') == 'yes' ? true : false);
            }
        );
    }

    //type text
    public function customize_type_text($wp_customize, $label, $section_id, $name,  $default = "", $callback = null)
    {
        // add settings
        $wp_customize->add_setting($name, array(
            'default'  => $default,
            'type'     => 'theme_mod'
        ));

        $wp_customize->add_control(new \WP_Customize_Control(
            $wp_customize,
            $name,
            array(
                "label" => $label,
                "section" => $section_id,
                "settings" => $name,
                "type" => "text",
                "active_callback" => $callback,
            )
        ));
    }


    //type color
    public function customize_type_color($wp_customize, $label, $section_id, $name,  $default)
    {
        // add settings
        $wp_customize->add_setting($name, array(
            'default'  => sanitize_hex_color($default),
            'type'     => 'theme_mod'
        ));

        // Add control
        $wp_customize->add_control(new \WP_Customize_Color_Control($wp_customize, $name, array(
            'label'    => $label,
            'section'  => $section_id,
            'setting' => $name,
            'priority' => 1
        )));
    }

    // type checkbox
    public function customize_type_checkbox($wp_customize, $label, $section_id, $name,  $default, $callback = null)
    {
        $wp_customize->add_setting($name, array(
            "default" => $default,
            "transport" => "refresh",

        ));

        $wp_customize->add_control(new \WP_Customize_Control(
            $wp_customize,
            $name,
            array(
                "label" => $label,
                "section" => $section_id,
                "settings" => $name,
                "type" => "checkbox",
                "active_callback" => $callback,
            )
        ));
    }

    // type Image
    public function customize_type_image($wp_customize, $label, $section_id, $name,  $default = '', $callback = null)
    {
        $wp_customize->add_setting($name, array(
            "default" => $default,
            "transport" => "refresh",

        ));

        $wp_customize->add_control(new \WP_Customize_Upload_Control($wp_customize, $name, array(
            'label'    => $label,
            'section'  => $section_id,
            'setting' => $name,
            'priority' => 20,
            "active_callback" => $callback,
        )));
    }

    public function customize_type_select($wp_customize, $label, $section_id, $name,  $default, $select_value,  $callback = null)
    {
        $wp_customize->add_setting($name, array(
            'default'     => $default,
            "transport" => "refresh",

        ));

        $wp_customize->add_control(new \WP_Customize_Control(
            $wp_customize,
            $name,
            array(
                "label" => $label,
                "section" => $section_id,
                "settings" => $name,
                "type" => "select",
                'choices'     => $select_value,
                "active_callback" => $callback,
            )
        ));
    }

    public function customize_type_radio($wp_customize, $label, $section_id, $name,  $default, $radio_value, $callback = null)
    {
        $wp_customize->add_setting($name, array(
            'default'     => $default,
            "transport" => "refresh",

        ));

        $wp_customize->add_control(new \WP_Customize_Control(
            $wp_customize,
            $name,
            array(
                "label" => $label,
                "section" => $section_id,
                "settings" => $name,
                "type" => "radio",
                'choices'     => $radio_value,
                "active_callback" => $callback,
            )
        ));
    }
}
