<?php

namespace Layerdrops\Agrion;

class Assets
{

    /**
     * Class constructor
     */
    function __construct()
    {
        add_action('wp_enqueue_scripts', [$this, 'register_assets']);
        add_action('admin_enqueue_scripts', [$this, 'register_assets']);
    }

    /**
     * All available scripts
     *
     * @return array
     */
    public function get_scripts()
    {
        return [
            'bootstrap-select' => [
                'src'     => AGRION_ADDON_ASSETS . '/vendors/bootstrap-select/js/bootstrap-select.min.js',
                'version' => filemtime(AGRION_ADDON_PATH . '/assets/vendors/bootstrap-select/js/bootstrap-select.min.js'),
                'deps'    => ['jquery', 'bootstrap']
            ],
            'jquery-bxslider' => [
                'src'     => AGRION_ADDON_ASSETS . '/vendors/bxslider/jquery.bxslider.min.js',
                'version' => filemtime(AGRION_ADDON_PATH . '/assets/vendors/bxslider/jquery.bxslider.min.js'),
                'deps'    => ['jquery']
            ],
            'countdown' => [
                'src'     => AGRION_ADDON_ASSETS . '/vendors/countdown/countdown.min.js',
                'version' => filemtime(AGRION_ADDON_PATH . '/assets/vendors/countdown/countdown.min.js'),
                'deps'    => ['jquery']
            ],
            'jarallax' => [
                'src'     => AGRION_ADDON_ASSETS . '/vendors/jarallax/jarallax.min.js',
                'version' => filemtime(AGRION_ADDON_PATH . '/assets/vendors/jarallax/jarallax.min.js'),
                'deps'    => ['jquery']
            ],
            'jquery-ajaxchimp' => [
                'src'     => AGRION_ADDON_ASSETS . '/vendors/jquery-ajaxchimp/jquery.ajaxchimp.min.js',
                'version' => filemtime(AGRION_ADDON_PATH . '/assets/vendors/jquery-ajaxchimp/jquery.ajaxchimp.min.js'),
                'deps'    => ['jquery']
            ],
            'jquery-appear' => [
                'src'     => AGRION_ADDON_ASSETS . '/vendors/jquery-appear/jquery.appear.min.js',
                'version' => filemtime(AGRION_ADDON_PATH . '/assets/vendors/jquery-appear/jquery.appear.min.js'),
                'deps'    => ['jquery']
            ],
            'jquery-circle-progress' => [
                'src'     => AGRION_ADDON_ASSETS . '/vendors/jquery-circle-progress/jquery.circle-progress.min.js',
                'version' => filemtime(AGRION_ADDON_PATH . '/assets/vendors/jquery-circle-progress/jquery.circle-progress.min.js'),
                'deps'    => ['jquery']
            ],
            'jquery-magnific-popup' => [
                'src'     => AGRION_ADDON_ASSETS . '/vendors/jquery-magnific-popup/jquery.magnific-popup.min.js',
                'version' => filemtime(AGRION_ADDON_PATH . '/assets/vendors/jquery-magnific-popup/jquery.magnific-popup.min.js'),
                'deps'    => ['jquery']
            ],
            'odometer' => [
                'src'     => AGRION_ADDON_ASSETS . '/vendors/odometer/odometer.min.js',
                'version' => filemtime(AGRION_ADDON_PATH . '/assets/vendors/odometer/odometer.min.js'),
                'deps'    => ['jquery']
            ],
            'owl-carousel' => [
                'src'     => AGRION_ADDON_ASSETS . '/vendors/owl-carousel/owl.carousel.min.js',
                'version' => filemtime(AGRION_ADDON_PATH . '/assets/vendors/owl-carousel/owl.carousel.min.js'),
                'deps'    => ['jquery']
            ],
            'swiper' => [
                'src'     => AGRION_ADDON_ASSETS . '/vendors/swiper/swiper.min.js',
                'version' => filemtime(AGRION_ADDON_PATH . '/assets/vendors/swiper/swiper.min.js'),
                'deps'    => ['jquery']
            ],
            'wow' => [
                'src'     => AGRION_ADDON_ASSETS . '/vendors/wow/wow.js',
                'version' => filemtime(AGRION_ADDON_PATH . '/assets/vendors/wow/wow.js'),
                'deps'    => ['jquery']
            ],

            'sharer' => [
                'src'     => AGRION_ADDON_ASSETS . '/vendors/sharer/sharer.min.js',
                'version' => filemtime(AGRION_ADDON_PATH . '/assets/vendors/sharer/sharer.min.js'),
                'deps'    => ['jquery']
            ],

            'select2' => [
                'src'     => AGRION_ADDON_ASSETS . '/vendors/select2/js/select2.min.js',
                'version' => filemtime(AGRION_ADDON_PATH . '/assets/vendors/select2/js/select2.min.js'),
                'deps'    => ['jquery']
            ],
            'agrion-addon-customizer' => [
                'src'     => AGRION_ADDON_ASSETS . '/js/agrion-addon-customizer.js',
                'version' => filemtime(AGRION_ADDON_PATH . '/assets/js/agrion-addon-customizer.js'),
                'deps'    => ['jquery', 'select2']
            ],
            'agrion-addon-script' => [
                'src'     => AGRION_ADDON_ASSETS . '/js/agrion-addon.js',
                'version' => filemtime(AGRION_ADDON_PATH . '/assets/js/agrion-addon.js'),
                'deps'    => ['jquery']
            ]
        ];
    }

    /**
     * All available styles
     *
     * @return array
     */
    public function get_styles()
    {
        return [
            'animate' => [
                'src'     => AGRION_ADDON_ASSETS . '/vendors/animate/animate.min.css',
                'version' => filemtime(AGRION_ADDON_PATH . '/assets/vendors/animate/animate.min.css')
            ],
            'custom-animate' => [
                'src'     => AGRION_ADDON_ASSETS . '/vendors/animate/custom-animate.css',
                'version' => filemtime(AGRION_ADDON_PATH . '/assets/vendors/animate/custom-animate.css')
            ],
            'bootstrap-select' => [
                'src'     => AGRION_ADDON_ASSETS . '/vendors/bootstrap-select/css/bootstrap-select.min.css',
                'version' => filemtime(AGRION_ADDON_PATH . '/assets/vendors/bootstrap-select/css/bootstrap-select.min.css')
            ],
            'bxslider' => [
                'src'     => AGRION_ADDON_ASSETS . '/vendors/bxslider/jquery.bxslider.css',
                'version' => filemtime(AGRION_ADDON_PATH . '/assets/vendors/bxslider/jquery.bxslider.css')
            ],
            'jarallax' => [
                'src'     => AGRION_ADDON_ASSETS . '/vendors/jarallax/jarallax.css',
                'version' => filemtime(AGRION_ADDON_PATH . '/assets/vendors/jarallax/jarallax.css')
            ],
            'jquery-magnific-popup' => [
                'src'     => AGRION_ADDON_ASSETS . '/vendors/jquery-magnific-popup/jquery.magnific-popup.css',
                'version' => filemtime(AGRION_ADDON_PATH . '/assets/vendors/jquery-magnific-popup/jquery.magnific-popup.css')
            ],
            'odometer' => [
                'src'     => AGRION_ADDON_ASSETS . '/vendors/odometer/odometer.min.css',
                'version' => filemtime(AGRION_ADDON_PATH . '/assets/vendors/odometer/odometer.min.css')
            ],
            'owl-carousel' => [
                'src'     => AGRION_ADDON_ASSETS . '/vendors/owl-carousel/owl.carousel.min.css',
                'version' => filemtime(AGRION_ADDON_PATH . '/assets/vendors/owl-carousel/owl.carousel.min.css')
            ],
            'owl-theme' => [
                'src'     => AGRION_ADDON_ASSETS . '/vendors/owl-carousel/owl.theme.default.min.css',
                'version' => filemtime(AGRION_ADDON_PATH . '/assets/vendors/owl-carousel/owl.theme.default.min.css')
            ],
            'reey-font' => [
                'src'     => AGRION_ADDON_ASSETS . '/vendors/reey-font/stylesheet.css',
                'version' => filemtime(AGRION_ADDON_PATH . '/assets/vendors/reey-font/stylesheet.css')
            ],
            'swiper' => [
                'src'     => AGRION_ADDON_ASSETS . '/vendors/swiper/swiper.min.css',
                'version' => filemtime(AGRION_ADDON_PATH . '/assets/vendors/swiper/swiper.min.css')
            ],
            'select2' => [
                'src'     => AGRION_ADDON_ASSETS . '/vendors/select2/css/select2.min.css',
                'version' => filemtime(AGRION_ADDON_PATH . '/assets/vendors/select2/css/select2.min.css')
            ],
            'agrion-addon-style' => [
                'src'     => AGRION_ADDON_ASSETS . '/css/agrion-addon.css',
                'version' => filemtime(AGRION_ADDON_PATH . '/assets/css/agrion-addon.css')
            ],
            'agrion-addon-admin-style' => [
                'src'     => AGRION_ADDON_ASSETS . '/css/agrion-addon-admin.css',
                'version' => filemtime(AGRION_ADDON_PATH . '/assets/css/agrion-addon-admin.css')
            ]
        ];
    }

    /**
     * Register scripts and styles
     *
     * @return void
     */
    public function register_assets()
    {
        $scripts = $this->get_scripts();
        $styles  = $this->get_styles();

        foreach ($scripts as $handle => $script) {
            $deps = isset($script['deps']) ? $script['deps'] : false;

            wp_register_script($handle, $script['src'], $deps, $script['version'], true);
        }

        foreach ($styles as $handle => $style) {
            $deps = isset($style['deps']) ? $style['deps'] : false;

            wp_register_style($handle, $style['src'], $deps, $style['version']);
        }
    }
}
