<?php if ('layout_two' === $settings['layout_type']) : ?>
    <!--Testimonial Two Start-->
    <section class="testimonial-two">
        <div class="testimonial-two__shape-1 float-bob-x" style="
            background-image: url(<?php echo esc_url($settings['layout_two_bg_image']['url']); ?>);
          "></div>
        <div class="container">
            <div class="row">
                <div class="col-xl-7 col-lg-6">
                    <div class="testimonial-two__left">
                        <?php if (!empty($settings['layout_two_sec_sub_title']) || !empty($settings['layout_two_sec_title'])) : ?>
                            <div class="section-title text-left">
                                <?php
                                if (!empty($settings['layout_two_sec_sub_title'])) :
                                    $this->add_inline_editing_attributes('layout_two_sec_sub_title', 'none');
                                    agrion_elementor_rendered_content($this, 'layout_two_sec_sub_title', 'section-title__tagline', $settings['section_sub_title_tag_layout_two']);
                                endif;

                                if (!empty($settings['layout_two_sec_title'])) :
                                    $this->add_inline_editing_attributes('layout_two_sec_title', 'none');
                                    agrion_elementor_rendered_content($this, 'layout_two_sec_title', 'section-title__title', $settings['section_title_tag_layout_two']);
                                endif;
                                ?>
                                <div class="section-title__icon">
                                    <?php agrion_elementor_rendered_image($settings, 'layout_two_sec_title_shape'); ?>
                                </div>
                            </div>
                        <?php endif; ?>
                        <div class="testimonial-two__slider">
                            <div class="testimonials-two__thumb-wrapper">
                                <div class="swiper-container" id="testimonials-two__thumb">
                                    <div class="swiper-wrapper">
                                        <?php foreach ($settings['layout_two_testimonials'] as $index => $item) : ?>
                                            <div class="swiper-slide">
                                                <div class="testimonial-two__img-holder">
                                                    <?php agrion_elementor_rendered_image($item, 'image'); ?>
                                                </div>
                                            </div>
                                        <?php endforeach; ?>
                                    </div>
                                </div>
                            </div>
                            <!-- /.testimonials-one__thumb-wrapper -->

                            <div class="testimonial-two__main-content">
                                <div class="swiper-container" id="testimonials-two__carousel">
                                    <div class="swiper-wrapper">
                                        <?php foreach ($settings['layout_two_testimonials'] as $index => $item) : ?>
                                            <div class="swiper-slide">
                                                <div class="testimonial-two__content-box">
                                                    <?php
                                                    if (!empty($item['testimonial'])) :
                                                        agrion_basic_rendered_content($this, $item,  'testimonial', 'testimonial-two__text', 'p');
                                                    endif;
                                                    ?>
                                                    <div class="testimonial-two__client-info">
                                                        <p class="testimonial-two__client-text">
                                                            <?php echo esc_html($item['name']); ?> <span><?php echo esc_html($item['designation']); ?></span>
                                                        </p>
                                                    </div>
                                                    <div class="testimonial-two__quote icon-svg">
                                                        <?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- /.swiper-slide -->
                                        <?php endforeach; ?>
                                    </div>
                                </div>
                            </div>

                            <div id="testimonials-one__carousel-pagination"></div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-5 col-lg-6">
                    <div class="testimonial-two__right">
                        <ul class="testimonial-two__counter list-unstyled ml-0">
                            <?php foreach ($settings['layout_two_features_list'] as $index => $item) : ?>
                                <li>
                                    <div class="testimonial-two__counter-icon icon-svg">
                                        <?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?>
                                    </div>
                                    <div class="testimonial-two__counter-content-box">
                                        <div class="testimonial-two__counter-count-box">
                                            <h3 class="odometer" data-count="<?php echo esc_attr($item['count_number']); ?>">00</h3>
                                            <span class="counter-one__plus"><?php echo esc_html($item['sign']); ?></span>
                                        </div>
                                        <p class="testimonial-two__counter-text">
                                            <?php echo esc_html($item['title']); ?>
                                        </p>
                                    </div>
                                </li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--Testimonial Two End-->
<?php endif; ?>