<?php if ('layout_one' === $settings['layout_type']) : ?>
    <!--Testimonial One Start-->
    <section class="testimonial-one">
        <div class="testimonial-one-bg" style="
            background-image: url(<?php echo esc_url($settings['bg_image']['url']); ?>);
          "></div>
        <div class="container">
            <div class="row">
                <div class="col-xl-12">
                    <div class="testimonial-one__top">
                        <div class="section-title text-center">
                            <?php
                            if (!empty($settings['sec_sub_title'])) :
                                $this->add_inline_editing_attributes('sec_sub_title', 'none');
                                agrion_elementor_rendered_content($this, 'sec_sub_title', 'section-title__tagline', $settings['section_sub_title_tag_layout_one']);
                            endif;

                            if (!empty($settings['sec_title'])) :
                                $this->add_inline_editing_attributes('sec_title', 'none');
                                agrion_elementor_rendered_content($this, 'sec_title', 'section-title__title', $settings['section_title_tag_layout_one']);
                            endif;
                            ?>
                            <div class="section-title__icon">
                                <?php agrion_elementor_rendered_image($settings, 'sec_title_shape'); ?>
                            </div>
                        </div>
                    </div>
                    <div class="testimonial-one__bottom">
                        <div class="testimonial-one__carousel owl-carousel owl-theme thm-owl__carousel" data-owl-options='<?php echo esc_attr(agrion_get_owl_options($settings)); ?>'>
                            <?php foreach ($settings['testimonials'] as $index => $item) : ?>
                                <!--Testimonial One Single Start-->
                                <div class="item">
                                    <div class="testimonial-one__single">
                                        <div class="testimonial-one__content">
                                            <?php
                                            if (!empty($item['testimonial'])) :
                                                agrion_basic_rendered_content($this, $item,  'testimonial', 'testimonial-one__text', 'p');
                                            endif;
                                            ?>
                                            <div class="testimonial-one__client-info">
                                                <div class="testimonial-one__client-img">
                                                    <?php agrion_elementor_rendered_image($item, 'image'); ?>
                                                    <div class="testimonial-one__quote icon-svg">
                                                        <?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="testimonial-one__client-details-box">
                                            <div class="testimonial-one__client-details">
                                                <?php
                                                if (!empty($item['name'])) :
                                                    agrion_basic_rendered_content($this, $item,  'name', 'testimonial-one__client-name', 'h4');
                                                endif;

                                                if (!empty($item['designation'])) :
                                                    agrion_basic_rendered_content($this, $item,  'designation', 'testimonial-one__client-sub-title', 'p');
                                                endif;

                                                ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!--Testimonial One Single End-->
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--Testimonial One End-->
<?php endif; ?>