<?php if ('layout_five' === $settings['layout_type']) : ?>
    <!--Testimonial page Start-->
    <section class="testimonials-carousel-page">
        <div class="container">
            <div class="testimonials-carousel-box thm-owl__carousel owl-theme owl-carousel carousel-dot-style" data-owl-options='<?php echo esc_attr(agrion_get_owl_options($settings)); ?>'>
                <?php foreach ($settings['layout_five_testimonials'] as $index => $item) : ?>
                    <!--Testimonial Page Single Start-->
                    <div class="item">
                        <div class="testimonial-one__single">
                            <div class="testimonial-one__content">
                                <?php
                                if (!empty($item['testimonial'])) :
                                    agrion_basic_rendered_content($this, $item,  'testimonial', 'testimonial-one__text', 'p');
                                endif;
                                ?>
                                <div class="testimonial-one__client-info">
                                    <div class="testimonial-one__client-img">
                                        <?php agrion_elementor_rendered_image($item, 'image'); ?>
                                        <div class="testimonial-one__quote icon-svg">
                                            <?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="testimonial-one__client-details-box">
                                <div class="testimonial-one__client-details">
                                    <?php
                                    if (!empty($item['name'])) :
                                        agrion_basic_rendered_content($this, $item,  'name', 'testimonial-one__client-name', 'h4');
                                    endif;

                                    if (!empty($item['designation'])) :
                                        agrion_basic_rendered_content($this, $item,  'designation', 'testimonial-one__client-sub-title', 'p');
                                    endif;

                                    ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!--Testimonial Page Single End-->
                <?php endforeach; ?>
            </div>
        </div>
    </section>
    <!--Testimonial page End-->
<?php endif; ?>