<?php if ('layout_three' == $settings['layout_type']) : ?>
	<!--Team Carousel Page Start-->
	<section class="team-carousel-page">
		<div class="container">
			<div class="team-carousel thm-owl__carousel owl-theme owl-carousel carousel-dot-style" data-owl-options='<?php echo esc_attr(agrion_get_owl_options($settings)); ?>'>
				<?php foreach ($settings['layout_three_team_items'] as $index => $item) : ?>
					<!--Team Page Single Start-->
					<div class="item">
						<div class="team-one__single">
							<div class="team-one__shape-1">
								<?php agrion_elementor_rendered_image($item, 'shape'); ?>
							</div>
							<div class="team-one__img-box">
								<div class="team-one__img">
									<?php agrion_elementor_rendered_image($item, 'image'); ?>
									<ul class="list-unstyled team-one__social">
										<?php echo wp_kses($item['social_network'], 'agrion_allowed_tags'); ?>
									</ul>
									<div class="team-one__icon">
										<a href="#"><i class="fas fa-share-alt"></i></a>
									</div>
								</div>
							</div>
							<div class="team-one__content">
								<h3 class="team-one__title">
									<?php
									if (!empty($item['name'])) :
										agrion_basic_rendered_content($this, $item,  'name', '', 'a');
									endif;
									?>
								</h3>
								<?php
								if (!empty($item['designation'])) :
									agrion_basic_rendered_content($this, $item,  'designation', 'team-one__subtitle', 'p');
								endif;
								?>
							</div>
						</div>
					</div>
					<!--Team Page Single End-->
				<?php endforeach; ?>
			</div>
		</div>
	</section>
	<!--Team Carousel Page End-->

<?php endif; ?>