<?php if ('layout_one' == $settings['layout_type']) : ?>

	<!--Team One Start-->
	<section class="team-one">
		<div class="container">
			<div class="section-title text-center">
				<?php
				if (!empty($settings['sec_sub_title'])) :
					$this->add_inline_editing_attributes('sec_sub_title', 'none');
					agrion_elementor_rendered_content($this, 'sec_sub_title', 'section-title__tagline', $settings['section_sub_title_tag_layout_one']);
				endif;

				if (!empty($settings['sec_title'])) :
					$this->add_inline_editing_attributes('sec_title', 'none');
					agrion_elementor_rendered_content($this, 'sec_title', 'section-title__title', $settings['section_title_tag_layout_one']);
				endif;
				?>
				<div class="section-title__icon">
					<?php agrion_elementor_rendered_image($settings, 'sec_title_shape'); ?>
				</div>
			</div>
			<div class="row">
				<?php foreach ($settings['team_items'] as $index => $item) : ?>
					<!--Team One Single Start-->
					<div class="col-xl-4 col-lg-4 wow fadeInUp" data-wow-delay="<?php echo esc_attr($index + 1); ?>00ms">
						<div class="team-one__single">
							<div class="team-one__shape-1">
								<?php agrion_elementor_rendered_image($item, 'shape'); ?>
							</div>
							<div class="team-one__img-box">
								<div class="team-one__img">
									<?php agrion_elementor_rendered_image($item, 'image'); ?>
									<ul class="list-unstyled team-one__social">
										<?php echo wp_kses($item['social_network'], 'agrion_allowed_tags'); ?>
									</ul>
									<div class="team-one__icon">
										<a href="#"><i class="fas fa-share-alt"></i></a>
									</div>
								</div>
							</div>
							<div class="team-one__content">
								<h3 class="team-one__title">
									<?php
									if (!empty($item['name'])) :
										agrion_basic_rendered_content($this, $item,  'name', '', 'a');
									endif;
									?>
								</h3>
								<?php
								if (!empty($item['designation'])) :
									agrion_basic_rendered_content($this, $item,  'designation', 'team-one__subtitle', 'p');
								endif;
								?>
							</div>
						</div>
					</div>
					<!--Team One Single End-->
				<?php endforeach; ?>
			</div>
		</div>
	</section>
	<!--Team One End-->

<?php endif; ?>