<?php if ('layout_three' === $settings['layout_type']) : ?>
	<div class="project-details__details-box">
		<?php agrion_elementor_rendered_image($settings, 'layout_three_bg_image', 'project-details__bg-shape'); ?>
		<?php if (is_array($settings['layout_three_items'])) : ?>
			<ul class="list-unstyled project-details__details-list ml-0">
				<?php foreach ($settings['layout_three_items'] as $key => $item) :
				?>
					<li>
						<?php
						if (!empty($item['title'])) :
							agrion_basic_rendered_content($this, $item,  'title', 'project-details__client', 'p');
						endif;
						?>
						<?php
						if (!empty($item['info'])) :
							agrion_basic_rendered_content($this, $item,  'info', 'project-details__name', 'h4');
						endif;
						?>
					</li>
				<?php endforeach; ?>
				<?php if (is_array($settings['layout_three_social_icons'])) : ?>
					<li>
						<div class="project-details__social">
							<?php foreach ($settings['layout_three_social_icons'] as $item) : ?>
								<a class="icon-svg" href="<?php echo esc_url($item['social_url']['url']); ?>">
									<?php \Elementor\Icons_Manager::render_icon($item['social_icon'], ['aria-hidden' => 'true', 'class' => ' '], 'i'); ?>
								</a>
							<?php endforeach; ?>
						</div>
					</li>
				<?php endif; ?>
			</ul>
		<?php endif; ?>
	</div>
<?php endif; ?>