<?php
if ('layout_two' == $settings['layout_type']) :
	$product_category = $settings['select_product_category'];
?>
	<!--New Product Two Start-->
	<section class="new-product-two">
		<div class="container">
			<?php if (!empty($settings['sec_sub_title']) || !empty($settings['sec_title'])) : ?>
				<div class="section-title text-center">
					<?php
					if (!empty($settings['sec_sub_title'])) :
						$this->add_inline_editing_attributes('sec_sub_title', 'none');
						agrion_elementor_rendered_content($this, 'sec_sub_title', 'section-title__tagline', $settings['section_sub_title_tag_layout_one']);
					endif;

					if (!empty($settings['sec_title'])) :
						$this->add_inline_editing_attributes('sec_title', 'none');
						agrion_elementor_rendered_content($this, 'sec_title', 'section-title__title', $settings['section_title_tag_layout_one']);
					endif;
					?>
					<div class="section-title__icon">
						<?php agrion_elementor_rendered_image($settings, 'sec_title_shape'); ?>
					</div>
				</div>
			<?php endif; ?>
			<?php if ('yes' === $settings['show_filter'] && !empty($product_category) && !is_wp_error($product_category)) : ?>
				<div class="row">
					<div class="col-xl-12">
						<div class="new-product-two__top">
							<ul class="new-product-two__filter style1 post-filter list-unstyled clearfix">
								<li data-filter=".filter-item" class="active"><span class="filter-text"><?php esc_html_e('All', 'agrion-addon'); ?></span>
								</li>
								<?php
								foreach ($product_category as $category) :
									$cat = get_term_by('slug', $category, 'product_cat');
									$cat_slug = $cat->slug;
								?>
									<li data-filter=".<?php echo esc_attr($cat_slug); ?>"><span class="filter-text"><?php echo esc_html($cat->name); ?></span></li>
								<?php endforeach; ?>
							</ul>
						</div>
					</div>
				</div>
			<?php endif; ?>
			<div class="row filter-layout masonary-layout">
				<?php
				if (!empty($settings['select_product_category'])) :
					$shop_post_query = new \WP_Query(array(
						'post_type' => 'product',
						'posts_per_page' => $settings['post_count']['size'],
						'orderby' => 'menu_order title',
						'order'   => $settings['query_order'],
						'tax_query' => array(
							array(
								'taxonomy' => 'product_cat',
								'field' => 'slug',
								'terms' => $settings['select_product_category']
							)
						)
					));

				else :

					$shop_post_query = new \WP_Query(array(
						'post_type' => 'product',
						'posts_per_page' => $settings['post_count']['size'],
						'orderby' => 'menu_order title',
						'order'   => $settings['query_order'],
					));

				endif;
				$i = 1;
				while ($shop_post_query->have_posts()) :
					$shop_post_query->the_post();
					global $product;
					$price = get_post_meta(get_the_ID(), '_price', true);
					$product_category =  get_the_terms(get_the_ID(), 'product_cat');
				?>
					<!--New Product Single Start-->
					<div class="col-xl-3 col-lg-6 col-md-6 filter-item <?php if (is_array($product_category))
																			foreach ($product_category as $cat) {
																				echo esc_attr(' ' . $cat->slug);
																			} ?>">
						<div class="new-product__single">
							<div class="new-product__img-box">
								<div class="new-product__img">
									<?php
									if (has_post_thumbnail()) :
										the_post_thumbnail('agrion_product_268X305');
									endif;
									?>
									<?php if ($product->is_on_sale()) : ?>
										<span class="new-product__sale"><?php esc_html_e('Sale', 'agrion-addon'); ?></span>
									<?php endif; ?>
									<div class="new-product__img-icon">
										<?php
										if ($product->is_type('variable')) {
											echo sprintf(
												'<a href="%s" class="%s">%s</a>',
												esc_url($product->add_to_cart_url()),
												esc_attr(implode(' ', array_filter(array(
													'button', 'product_type_' . $product->get_type(),
													'shop-one__cart add_to_cart_button'
												)))),
												'<i class="icon-shopping-cart"></i>'
											);
										} else {
											echo sprintf(
												'<a href="%s" data-quantity="1" class="%s" %s>%s</a>',
												esc_url($product->add_to_cart_url()),
												esc_attr(implode(' ', array_filter(array(
													'button', 'product_type_' . $product->get_type(),
													$product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button' : '',
													$product->supports('ajax_add_to_cart') ? 'ajax_add_to_cart shop-one__cart agrion_ajax' : 'shop-one__cart',
												)))),
												wc_implode_html_attributes(array(
													'data-product_id'  => $product->get_id(),
													'data-product_sku' => $product->get_sku(),
													'aria-label'       => $product->add_to_cart_description(),
													'rel'              => 'nofollow',
												)),
												'<i class="icon-shopping-cart"></i>'
											);
										}
										?>
									</div>
								</div>
							</div>
							<div class="new-product__content">
								<div class="new-product__rating">
									<?php wc_get_template('single-product/rating.php'); ?>
								</div>
								<h3 class="new-product__title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
								<p class="new-product__price"><?php echo wc_price($price); ?></p>
							</div>
						</div>
					</div>
					<!--New Product Single End-->
				<?php endwhile; ?>
				<?php wp_reset_postdata(); ?>
			</div>
		</div>
	</section>
	<!--New Product Two End-->
<?php endif; ?>