<?php if ('layout_three' === $settings['layout_type']) : ?>

	<!--Services Two Start-->
	<section class="services-page">
		<div class="container">
			<div class="row">
				<?php if (is_array($settings['layout_three_service_items'])) : ?>
					<?php $i = 1;
					foreach ($settings['layout_three_service_items'] as $index => $item) : ?>
						<!--Services Two Single Start-->
						<div class="col-xl-4 col-lg-4 wow fadeInUp" data-wow-delay="100ms">
							<div class="services-two__single">
								<div class="services-two__img">
									<?php agrion_elementor_rendered_image($item, 'image'); ?>
								</div>
								<div class="services-two__content">
									<div class="services-two__icon icon-svg-large">
										<?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?>
									</div>
									<div class="services-two__more-details">
										<a <?php echo esc_attr(!empty($item['url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($item['url']['url']); ?>">
											<?php \Elementor\Icons_Manager::render_icon($item['read_more_icon'], ['aria-hidden' => 'true', 'class' => ' '], 'i'); ?>
											<?php echo esc_html($item['read_more_txt']) ?>
										</a>
									</div>
								</div>
								<div class="services-two__title-box">
									<?php
									if (!empty($item['tag_line'])) :
										agrion_basic_rendered_content($this, $item,  'tag_line', 'services-two__subtitle', 'p');
									endif;
									?>
									<h3 class="services-two__title">
										<?php
										if (!empty($item['title'])) :
											agrion_basic_rendered_content($this, $item,  'title', '', 'a');
										endif;
										?>
									</h3>
								</div>
								<div class="services-two__hover-content">
									<?php
									if (!empty($item['tag_line'])) :
										agrion_basic_rendered_content($this, $item,  'tag_line', 'services-two__hover-sub-title', 'p');
									endif;
									?>
									<h3 class="services-two__hover-title">
										<?php
										if (!empty($item['title'])) :
											agrion_basic_rendered_content($this, $item,  'title', '', 'a');
										endif;
										?>
									</h3>
									<?php
									if (!empty($item['text'])) :
										agrion_basic_rendered_content($this, $item,  'text', 'services-two__hover-text', 'p');
									endif;
									?>
									<div class="services-two__hover-more-details">
										<a <?php echo esc_attr(!empty($item['url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($item['url']['url']); ?>">
											<?php \Elementor\Icons_Manager::render_icon($item['read_more_icon'], ['aria-hidden' => 'true', 'class' => ' '], 'i'); ?>
											<?php echo esc_html($item['read_more_txt']) ?>
										</a>
									</div>
								</div>
							</div>
						</div>
						<!--Services Two Single End-->
					<?php $i++;
					endforeach; ?>
				<?php endif; ?>
			</div>
		</div>
	</section>
	<!--Services Two End-->
<?php endif; ?>