<?php if ('layout_one' === $settings['layout_type']) : ?>


	<!--Services One Start-->
	<section class="services-one">
		<div class="services-one__bg" style="background-image: url(<?php echo esc_url($settings['bg_image']['url']); ?>);"></div>
		<div class="container">
			<?php if (!empty($settings['sec_sub_title']) || !empty($settings['sec_title'])) : ?>
				<div class="section-title text-center">
					<?php
					if (!empty($settings['sec_sub_title'])) :
						$this->add_inline_editing_attributes('sec_sub_title', 'none');
						agrion_elementor_rendered_content($this, 'sec_sub_title', 'section-title__tagline', $settings['section_sub_title_tag_layout_one']);
					endif;
					?>

					<?php
					if (!empty($settings['sec_title'])) :
						$this->add_inline_editing_attributes('sec_title', 'none');
						agrion_elementor_rendered_content($this, 'sec_title', 'section-title__title', $settings['section_title_tag_layout_one']);
					endif;
					?>
					<div class="section-title__icon">
						<?php agrion_elementor_rendered_image($settings, 'sec_title_shape'); ?>
					</div>
				</div>
			<?php endif; ?>
			<div class="row">
				<?php if (is_array($settings['layout_one_service_items'])) : ?>
					<?php $i = 1;
					foreach ($settings['layout_one_service_items'] as $index => $item) : ?>
						<!--Services One Single Start-->
						<div class="col-xl-3 col-lg-6 col-md-6 wow fadeInLeft" data-wow-delay="<?php echo esc_attr($i); ?>00ms">
							<div class="services-one__single">
								<div class="services-one__img-box">
									<div class="services-one__img">
										<?php agrion_elementor_rendered_image($item, 'image'); ?>
									</div>
									<div class="services-one__icon icon-svg-large">
										<?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?>
									</div>
								</div>
								<div class="services-one__content">
									<<?php echo esc_attr($item['service_title_tag_layout_one']); ?> class="services-one__title">
										<?php
										if (!empty($item['title'])) :
											agrion_basic_rendered_content($this, $item,  'title', '', 'a');
										endif;
										?>
									</<?php echo esc_attr($item['service_title_tag_layout_one']); ?>>
									<?php
									if (!empty($item['text'])) :
										agrion_basic_rendered_content($this, $item,  'text', 'services-one__text', 'p');
									endif;
									?>
								</div>
							</div>
						</div>
						<!--Services One Single End-->
					<?php $i++;
					endforeach; ?>
				<?php endif; ?>
			</div>
		</div>
	</section>
	<!--Services One End-->
<?php endif; ?>