<?php if ('layout_four' === $settings['layout_type']) : ?>
	<!--Services One Start-->
	<section class="services-carousel-page">
		<div class="container">
			<div class="services-carousel thm-owl__carousel owl-theme owl-carousel carousel-dot-style" data-owl-options='<?php echo esc_attr(agrion_get_owl_options($settings)); ?>'>
				<?php if (is_array($settings['layout_four_service_items'])) : ?>
					<?php $i = 1;
					foreach ($settings['layout_four_service_items'] as $index => $item) : ?>
						<!--Services One Single Start-->
						<div class="item">
							<div class="services-one__single">
								<div class="services-one__img-box">
									<div class="services-one__img">
										<?php agrion_elementor_rendered_image($item, 'image'); ?>
									</div>
									<div class="services-one__icon icon-svg-large">
										<?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?>
									</div>
								</div>
								<div class="services-one__content">
									<<?php echo esc_attr($item['service_title_tag_layout_four']); ?> class="services-one__title">
										<?php
										if (!empty($item['title'])) :
											agrion_basic_rendered_content($this, $item,  'title', '', 'a');
										endif;
										?>
									</<?php echo esc_attr($item['service_title_tag_layout_four']); ?>>
									<?php
									if (!empty($item['text'])) :
										agrion_basic_rendered_content($this, $item,  'text', 'services-one__text', 'p');
									endif;
									?>
								</div>
							</div>
						</div>
						<!--Services One Single End-->
					<?php $i++;
					endforeach; ?>
				<?php endif; ?>
			</div>
		</div>
	</section>
	<!--Services One End-->
<?php endif; ?>