<?php if ('layout_two' == $settings['layout_type']) : ?>
	<!--Project Two Start-->
	<section class="project-two">
		<div class="container">
			<?php if (!empty($settings['layout_two_sec_sub_title']) || !empty($settings['layout_two_sec_title'])) : ?>
				<div class="section-title text-center">
					<?php
					if (!empty($settings['layout_two_sec_sub_title'])) :
						$this->add_inline_editing_attributes('layout_two_sec_sub_title', 'none');
						agrion_elementor_rendered_content($this, 'layout_two_sec_sub_title', 'section-title__tagline', $settings['section_sub_title_tag_layout_two']);
					endif;

					if (!empty($settings['layout_two_sec_title'])) :
						$this->add_inline_editing_attributes('layout_two_sec_title', 'none');
						agrion_elementor_rendered_content($this, 'layout_two_sec_title', 'section-title__title', $settings['section_title_tag_layout_two']);
					endif;
					?>
					<div class="section-title__icon">
						<?php agrion_elementor_rendered_image($settings, 'layout_two_sec_title_shape'); ?>
					</div>
				</div>
			<?php endif; ?>
			<div class="project-two__carousel thm-owl__carousel owl-theme owl-carousel" data-owl-options='<?php echo esc_attr(agrion_get_owl_options($settings)); ?>'>
				<?php
				foreach ($settings['layout_two_project_items'] as $index => $item) : ?>
					<!--Project Two Single Start-->
					<div class="item">
						<div class="project-two__single">
							<div class="project-two__img">
								<?php agrion_elementor_rendered_image($item, 'image'); ?>
								<div class="project-two__content">
									<<?php echo esc_attr($item['project_title_tag_layout_two']); ?> class="project-two__title">
										<?php
										if (!empty($item['title'])) :
											agrion_basic_rendered_content($this, $item,  'title', '', 'a');
										endif;
										?>
									</<?php echo esc_attr($item['project_title_tag_layout_two']); ?>>
									<div class="project-two__arrow">
										<a <?php echo esc_attr(!empty($item['url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($item['url']['url']); ?>"><span class="icon-right-arrow"></span></a>
									</div>
								</div>
							</div>
						</div>
					</div>
					<!--Project Two Single End-->
				<?php endforeach; ?>
			</div>
		</div>
	</section>
	<!--Project Two End-->
<?php endif; ?>