<?php if ('layout_one' === $settings['layout_type']) : ?>

	<!--Project One Start-->
	<section class="project-one">
		<div class="project-one__bg float-bob-y-2" style="background-image: url(<?php echo esc_url($settings['bg_image']['url']); ?>);"></div>
		<div class="container">
			<?php if (!empty($settings['sec_sub_title']) || !empty($settings['sec_title'])) : ?>
				<div class="section-title text-center">
					<?php
					if (!empty($settings['sec_sub_title'])) :
						$this->add_inline_editing_attributes('sec_sub_title', 'none');
						agrion_elementor_rendered_content($this, 'sec_sub_title', 'section-title__tagline', $settings['section_sub_title_tag_layout_one']);
					endif;

					if (!empty($settings['sec_title'])) :
						$this->add_inline_editing_attributes('sec_title', 'none');
						agrion_elementor_rendered_content($this, 'sec_title', 'section-title__title', $settings['section_title_tag_layout_one']);
					endif;
					?>
					<div class="section-title__icon">
						<?php agrion_elementor_rendered_image($settings, 'sec_title_shape'); ?>
					</div>
				</div>
			<?php endif; ?>
			<div class="row">
				<?php
				foreach ($settings['layout_one_project_items'] as $index => $item) : ?>
					<!--Project One Single Start-->
					<div class="col-xl-3 col-lg-6 col-md-6 wow fadeInUp" data-wow-delay="<?php echo esc_attr($index + 1); ?>00ms">
						<div class="project-one__single">
							<div class="project-one__inner">
								<div class="project-one__img">
									<?php agrion_elementor_rendered_image($item, 'image'); ?>
								</div>
								<div class="project-one__arrow">
									<a <?php echo esc_attr(!empty($item['url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($item['url']['url']); ?>"><i class="icon-right-arrow"></i></a>
								</div>
								<div class="project-one__content">
									<?php
									if (!empty($item['tag_line'])) :
										agrion_basic_rendered_content($this, $item,  'tag_line', 'project-one__tagline', 'span');
									endif;
									?>
									<<?php echo esc_attr($item['project_title_tag_layout_one']); ?> class="project-one__title">
										<?php
										if (!empty($item['title'])) :
											agrion_basic_rendered_content($this, $item,  'title', '', 'a');
										endif;
										?>
									</<?php echo esc_attr($item['project_title_tag_layout_one']); ?>>
								</div>
							</div>
						</div>
					</div>
					<!--Project One Single Start-->
				<?php endforeach; ?>
			</div>
		</div>
	</section>
	<!--Project One End-->

<?php endif; ?>