<?php if ('layout_five' == $settings['layout_type']) : ?>
	<!--Project Page One Start-->
	<section class="project-carousel-page">
		<div class="container">
			<div class="project-carousel thm-owl__carousel owl-theme owl-carousel carousel-dot-style" data-owl-options='<?php echo esc_attr(agrion_get_owl_options($settings)); ?>'>
				<?php foreach ($settings['layout_five_project_items'] as $index => $item) : ?>
					<!--Project Page One Single Start-->
					<div class="item">
						<div class="project-one__single">
							<div class="project-one__inner">
								<div class="project-one__img">
									<?php agrion_elementor_rendered_image($item, 'image'); ?>
								</div>
								<div class="project-one__arrow">
									<a <?php echo esc_attr(!empty($item['url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($item['url']['url']); ?>"><i class="icon-right-arrow"></i></a>
								</div>
								<div class="project-one__content">
									<?php
									if (!empty($item['tag_line'])) :
										agrion_basic_rendered_content($this, $item,  'tag_line', 'project-one__tagline', 'span');
									endif;
									?>
									<<?php echo esc_attr($item['project_title_tag_layout_five']); ?> class="project-one__title">
										<?php
										if (!empty($item['title'])) :
											agrion_basic_rendered_content($this, $item,  'title', '', 'a');
										endif;
										?>
									</<?php echo esc_attr($item['project_title_tag_layout_five']); ?>>
								</div>
							</div>
						</div>
					</div>
					<!--Project Page One Single Start-->
				<?php endforeach; ?>
			</div>
		</div>
	</section>
	<!--Project Page One End-->
<?php endif; ?>