<?php if ('layout_three' === $settings['layout_type']) : ?>
	<!--Main Slider Start-->
	<section class="main-slider-three clearfix">
		<div class="swiper-container thm-swiper__slider" data-swiper-options='{"slidesPerView": <?php echo esc_attr($settings['items']['size']); ?>,
				"loop": <?php echo esc_attr(('yes' == $settings['loop']) ? 'true' : 'false'); ?>,
                "effect": "fade",
                "pagination": {
                "el": "#main-slider-pagination",
                "type": "bullets",
                "clickable": true
                },
                "navigation": {
                "nextEl": "#main-slider__swiper-button-next",
                "prevEl": "#main-slider__swiper-button-prev"
                },
                "autoplay": {
                "delay": <?php echo esc_attr($settings['delay']['size']); ?>
                }}'>
			<div class="swiper-wrapper">
				<?php foreach ($settings['layout_three_sliders'] as $slider) : ?>
					<div class="swiper-slide">
						<div class="image-layer-three" style="background-image: url(<?php echo esc_url($slider['background_image']['url']); ?>);"></div>
						<!-- /.image-layer -->
						<div class="container">
							<div class="row">
								<div class="col-xl-12">
									<div class="main-slider-three__content">
										<div class="main-slider-three__sub-title-box">
											<div class="main-slider-three__shape-1">
												<?php agrion_elementor_rendered_image($slider, 'sub_title_left_shape'); ?>
											</div>
											<div class="main-slider-three__shape-2">
												<?php agrion_elementor_rendered_image($slider, 'sub_title_right_shape'); ?>
											</div>
											<?php
											if (!empty($slider['sub_title'])) :
												agrion_basic_rendered_content($this, $slider,  'sub_title', 'main-slider-three__sub-title', $slider['sub_title_tag_layout_three']);
											endif;
											?>
										</div>
										<?php
										if (!empty($slider['title'])) :
											agrion_basic_rendered_content($this, $slider,  'title', 'main-slider-three__title', $slider['title_tag_layout_three']);
										endif;
										?>
										<div class="main-slider-three__btn-box">
											<?php
											if (!empty($slider['button_label'])) :
												agrion_basic_rendered_content($this, $slider,  'button_label', 'thm-btn main-slider-three__btn', 'a', 'button_url', '<i class="' . $slider['button_icon']['value'] . '"></i>');
											endif;
											?>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				<?php endforeach; ?>
			</div>
			<?php if ('yes' == $settings['enable_dots']) : ?>
				<div class="swiper-pagination" id="main-slider-pagination"></div>
			<?php endif; ?>
			<?php if ('yes' == $settings['enable_nav']) : ?>
				<!-- If we need navigation buttons -->
				<div class="main-slider__nav">
					<div class="swiper-button-prev" id="main-slider__swiper-button-next">
						<?php \Elementor\Icons_Manager::render_icon($settings['nav_left_icon'], ['aria-hidden' => 'true', 'class' => ' '], 'i'); ?>
					</div>
					<div class="swiper-button-next" id="main-slider__swiper-button-prev">
						<?php \Elementor\Icons_Manager::render_icon($settings['nav_right_icon'], ['aria-hidden' => 'true', 'class' => ' '], 'i'); ?>
					</div>
				</div>
			<?php endif; ?>
		</div>
	</section>
	<!--Main Slider End-->

<?php endif; ?>