<?php if ('layout_one' === $settings['layout_type']) : ?>

    <!--Main Slider Start-->
    <section class="main-slider clearfix">
        <div class="swiper-container thm-swiper__slider" data-swiper-options='{"slidesPerView": <?php echo esc_attr($settings['items']['size']); ?>,
                "loop": <?php echo esc_attr(('yes' == $settings['loop']) ? 'true' : 'false'); ?>,
                "effect": "fade",
                "pagination": {
                "el": "#main-slider-pagination",
                "type": "bullets",
                "clickable": true
                },
                "navigation": {
                "nextEl": "#main-slider__swiper-button-next",
                "prevEl": "#main-slider__swiper-button-prev"
                },
                "autoplay": {
                "delay": <?php echo esc_attr($settings['delay']['size']); ?>
                }}'>
            <div class="swiper-wrapper">
                <?php
                foreach ($settings['sliders'] as $index => $slider) :
                ?>
                    <div class="swiper-slide">
                        <div class="image-layer" style="background-image: url(<?php echo esc_url($slider['background_image']['url']); ?>);"></div>
                        <!-- /.image-layer -->
                        <div class="container">
                            <div class="row">
                                <div class="col-xl-12">
                                    <div class="main-slider__content">
                                        <?php

                                        if (!empty($slider['sub_title'])) :
                                            agrion_basic_rendered_content($this, $slider,  'sub_title', 'main-slider__sub-title', $slider['sub_title_tag_layout_one']);
                                        endif;

                                        if (!empty($slider['title'])) :
                                            agrion_basic_rendered_content($this, $slider,  'title', 'main-slider__title', $slider['title_tag_layout_one']);
                                        endif;

                                        if (!empty($slider['button_label'])) : ?>
                                            <div class="main-slider__btn-box">
                                                <?php agrion_basic_rendered_content($this, $slider,  'button_label', 'thm-btn main-slider__btn', 'a', 'button_url', '<i class="' . $slider['button_icon']['value'] . '"></i>'); ?>
                                            </div>
                                        <?php endif;
                                        ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
            <?php if ('yes' == $settings['enable_dots']) : ?>
                <div class="swiper-pagination" id="main-slider-pagination"></div>
            <?php endif; ?>
            <?php if ('yes' == $settings['enable_nav']) : ?>
                <!-- If we need navigation buttons -->
                <div class="main-slider__nav">
                    <div class="swiper-button-prev" id="main-slider__swiper-button-next">
                        <?php \Elementor\Icons_Manager::render_icon($settings['nav_left_icon'], ['aria-hidden' => 'true', 'class' => ' '], 'i'); ?>
                    </div>
                    <div class="swiper-button-next" id="main-slider__swiper-button-prev">
                        <?php \Elementor\Icons_Manager::render_icon($settings['nav_left_icon'], ['aria-hidden' => 'true', 'class' => ' '], 'i'); ?>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </section>
    <!--Main Slider End-->



<?php endif; ?>