<?php if ('layout_one' === $settings['layout_type']) : ?>

	<header class="main-header">
		<div class="main-header__wrapper">
			<div class="main-header__wrapper-inner">
				<div class="main-header__logo logo-retina">
					<a href="<?php echo esc_url(home_url('/')); ?>">
						<img width="<?php echo esc_attr($settings['logo_dimension']['width']); ?>" height="<?php echo esc_attr($settings['logo_dimension']['height']); ?>" src="<?php echo esc_url($settings['light_logo']['url']); ?>" alt="<?php echo esc_attr(get_bloginfo('name')); ?>">
					</a>
				</div>
				<div class="main-header__menu-box">
					<div class="main-header__menu-box-top">
						<?php if (is_array($settings['topbar_infos'])) :  ?>
							<ul class="list-unstyled main-header__contact-list ml-0">
								<?php foreach ($settings['topbar_infos'] as $info) : ?>
									<li>
										<div class="icon icon-svg">
											<?php \Elementor\Icons_Manager::render_icon($info['topbar_icon'], ['aria-hidden' => 'true', 'class' => ' '], 'i'); ?>
										</div>
										<div class="text">
											<p>
												<?php echo wp_kses($info['topbar_info_text'], 'agrion_allowed_tags'); ?>
											</p>
										</div>
									</li>
								<?php endforeach; ?>
							</ul>
						<?php endif; ?>
						<?php if (is_array($settings['nav_social_icons'])) : ?>
							<div class="main-header__social">
								<?php foreach ($settings['nav_social_icons'] as $social_icon) : ?>
									<a class="icon-svg" href="<?php echo esc_url($social_icon['social_url']['url']); ?>" <?php echo esc_attr(!empty($social_icon['social_url']['is_external']) ? 'target=_blank' : ' '); ?>>
										<?php \Elementor\Icons_Manager::render_icon($social_icon['social_icon'], ['aria-hidden' => 'true', 'class' => ' '], 'i'); ?>
									</a>
								<?php endforeach; ?>
							</div>
						<?php endif; ?>
					</div>
					<div class="main-header__menu-box-bottom">
						<nav class="main-menu">
							<div class="main-menu__wrapper">
								<div class="main-menu__wrapper-inner">
									<div class="main-menu__left">
										<div class="main-menu__main-menu-box">
											<a href="#" class="mobile-nav__toggler"><i class="fa fa-bars"></i></a>
											<?php
											wp_nav_menu(
												array(
													'menu' => $settings['nav_menu'],
													'menu_class' => 'main-menu__list',
													'walker'         => class_exists('\Layerdrops\Agrion\Megamenu\Walker_Nav_Menu') ? new \Layerdrops\Agrion\Megamenu\Walker_Nav_Menu : '',
												)
											);
											?>
										</div>
									</div>
									<div class="main-menu__right">
										<div class="main-menu__search-cart-btn-box">
											<?php if ('yes' == $settings['search_enable']) : ?>
												<div class="main-menu__search-box">
													<a href="#" class="main-menu__search search-toggler icon-magnifying-glass"></a>
												</div>
											<?php endif; ?>
											<?php if ('yes' == $settings['cart_enable'] && class_exists('WooCommerce')) : ?>
												<div class="main-menu__cart-box">
													<a href="<?php echo esc_url(wc_get_cart_url()); ?>" class="main-menu__cart icon-shopping-cart"></a>
												</div>
											<?php endif; ?>

											<div class="main-menu__btn-box">
												<?php
												if (!empty($settings['button_label'])) :
													agrion_basic_rendered_content($this, $settings,  'button_label', 'thm-btn main-menu__btn', 'a', 'button_url', '<i class="' . $settings['button_icon']['value'] . '"></i>');
												endif;

												?>
											</div>

										</div>
									</div>
								</div>
							</div>
						</nav>
					</div>
				</div>
				<?php if (!empty($settings['call_number'])) : ?>
					<div class="main-header__phone-contact-box">
						<div class="main-header__phone-number">
							<a href="<?php echo esc_url($settings['call_url']); ?>"><?php echo esc_html($settings['call_number']); ?></a>
						</div>
						<div class="main-header__call-box">
							<div class="main-header__call-inner">
								<div class="main-header__call-icon icon-svg">
									<?php \Elementor\Icons_Manager::render_icon($settings['call_icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?>
								</div>
							</div>
						</div>
					</div>
				<?php endif; ?>
			</div>
		</div>
	</header>

	<?php if (get_theme_mod('header_sticky_menu') == 'yes' && !is_admin_bar_showing()) : ?>
		<div class="stricky-header stricked-menu main-menu">
			<div class="sticky-header__content"></div>
			<!-- /.sticky-header__content -->
		</div>
		<!-- /.stricky-header -->
	<?php endif; ?>

<?php endif; ?>

<?php if ('layout_two' === $settings['layout_type']) : ?>

	<header class="main-header-two">
		<div class="main-header-two__inner">
			<div class="main-header-two__top">
				<div class="container">
					<div class="main-header-two__top-inner">
						<div class="main-header-two__logo logo-retina">
							<a href="<?php echo esc_url(home_url('/')); ?>">
								<img width="<?php echo esc_attr($settings['logo_dimension']['width']); ?>" height="<?php echo esc_attr($settings['logo_dimension']['height']); ?>" src="<?php echo esc_url($settings['light_logo']['url']); ?>" alt="<?php echo esc_attr(get_bloginfo('name')); ?>">
							</a>
						</div>
						<div class="main-header-two__top-left">
							<?php if (is_array($settings['topbar_infos'])) :  ?>
								<ul class="list-unstyled main-header-two__contact-list ml-0">
									<?php foreach ($settings['topbar_infos'] as $info) : ?>
										<li>
											<div class="icon icon-svg">
												<?php \Elementor\Icons_Manager::render_icon($info['topbar_icon'], ['aria-hidden' => 'true', 'class' => ' '], 'i'); ?>
											</div>
											<div class="text">
												<p>
													<?php echo wp_kses($info['topbar_info_text'], 'agrion_allowed_tags'); ?>
												</p>
											</div>
										</li>
									<?php endforeach; ?>
								</ul>
							<?php endif; ?>
						</div>
						<?php if (is_array($settings['nav_social_icons'])) : ?>
							<div class="main-header-two__top-right">
								<div class="main-header-two__social">
									<?php foreach ($settings['nav_social_icons'] as $social_icon) : ?>
										<a class="icon-svg" href="<?php echo esc_url($social_icon['social_url']['url']); ?>" <?php echo esc_attr(!empty($social_icon['social_url']['is_external']) ? 'target=_blank' : ' '); ?>>
											<?php \Elementor\Icons_Manager::render_icon($social_icon['social_icon'], ['aria-hidden' => 'true', 'class' => ' '], 'i'); ?>
										</a>
									<?php endforeach; ?>
								</div>
							</div>
						<?php endif; ?>
					</div>
				</div>
			</div>
			<div class="main-header-two__bottom">
				<nav class="main-menu main-menu-two">
					<div class="main-menu-two__wrapper">
						<div class="container">
							<div class="main-menu-two__wrapper-inner">
								<div class="main-menu-two__left">
									<div class="main-menu-two__main-menu-box">
										<a href="#" class="mobile-nav__toggler"><i class="fa fa-bars"></i></a>
										<?php
										wp_nav_menu(
											array(
												'menu' => $settings['nav_menu'],
												'menu_class' => 'main-menu__list',
												'walker'         => class_exists('\Layerdrops\Agrion\Megamenu\Walker_Nav_Menu') ? new \Layerdrops\Agrion\Megamenu\Walker_Nav_Menu : '',
											)
										);
										?>
									</div>
								</div>
								<div class="main-menu-two__right">
									<div class="main-menu-two__search-cart-btn-box">
										<?php if ('yes' == $settings['search_enable']) : ?>
											<div class="main-menu-two__search-box">
												<a href="#" class="main-menu-two__search search-toggler icon-magnifying-glass"></a>
											</div>
										<?php endif; ?>
										<?php if ('yes' == $settings['cart_enable'] && class_exists('WooCommerce')) : ?>
											<div class="main-menu-two__cart-box">
												<a href="<?php echo esc_url(wc_get_cart_url()); ?>" class="main-menu-two__cart icon-shopping-cart"></a>
											</div>
										<?php endif; ?>

										<div class="main-menu-two__btn-box">
											<?php
											if (!empty($settings['button_label'])) :
												agrion_basic_rendered_content($this, $settings,  'button_label', 'thm-btn main-menu__btn', 'a', 'button_url', '<i class="' . $settings['button_icon']['value'] . '"></i>');
											endif;
											?>
										</div>

									</div>
								</div>
							</div>
						</div>
					</div>
				</nav>
			</div>
		</div>
	</header>
	<?php if (get_theme_mod('header_sticky_menu') == 'yes' && !is_admin_bar_showing()) : ?>
		<div class="stricky-header stricked-menu main-menu main-menu-two">
			<div class="sticky-header__content"></div>
			<!-- /.sticky-header__content -->
		</div>
		<!-- /.stricky-header -->
	<?php endif; ?>
<?php endif; ?>

<?php if ('layout_three' === $settings['layout_type']) : ?>

	<header class="main-header-three">
		<div class="main-header-three__top">
			<div class="container">
				<div class="main-header-three__top-inner">
					<?php if (is_array($settings['topbar_infos'])) :  ?>
						<ul class="main-header-three__contact list-unstyled ml-0">
							<?php foreach ($settings['topbar_infos'] as $info) : ?>
								<li>
									<div class="icon icon-svg">
										<?php \Elementor\Icons_Manager::render_icon($info['topbar_icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?>
									</div>
									<div class="text">
										<p><?php echo wp_kses($info['topbar_info_text'], 'agrion_allowed_tags'); ?></p>
									</div>
								</li>
							<?php endforeach; ?>
						</ul>
					<?php endif; ?>
					<div class="main-header-three__logo logo-retina">
						<a href="<?php echo esc_url(home_url('/')); ?>">
							<img width="<?php echo esc_attr($settings['logo_dimension']['width']); ?>" height="<?php echo esc_attr($settings['logo_dimension']['height']); ?>" src="<?php echo esc_url($settings['light_logo']['url']); ?>" alt="<?php echo esc_attr(get_bloginfo('name')); ?>">
						</a>
					</div>
					<div class="main-menu-three__search-cart-btn-box">
						<?php if ('yes' == $settings['search_enable']) : ?>
							<div class="main-menu-three__search-box">
								<a href="#" class="main-menu-three__search search-toggler icon-magnifying-glass"></a>
							</div>
						<?php endif; ?>
						<?php if ('yes' == $settings['cart_enable'] && class_exists('WooCommerce')) : ?>
							<div class="main-menu-three__cart-box">
								<a href="<?php echo esc_url(wc_get_cart_url()); ?>" class="main-menu-three__cart icon-shopping-cart"></a>
							</div>
						<?php endif; ?>

						<div class="main-menu-three__btn-box">
							<?php
							if (!empty($settings['button_label'])) :
								agrion_basic_rendered_content($this, $settings,  'button_label', 'thm-btn main-menu__btn', 'a', 'button_url', '<i class="' . $settings['button_icon']['value'] . '"></i>');
							endif;
							?>
						</div>

					</div>
				</div>
			</div>
		</div>
		<nav class="main-menu main-menu-three">
			<div class="main-menu-three__wrapper">
				<div class="container">
					<div class="main-menu-three__wrapper-inner">
						<div class="main-menu-three__main-menu-box">
							<a href="#" class="mobile-nav__toggler"><i class="fa fa-bars"></i></a>
							<?php
							wp_nav_menu(
								array(
									'menu' => $settings['nav_menu'],
									'menu_class' => 'main-menu__list',
									'walker'         => class_exists('\Layerdrops\Agrion\Megamenu\Walker_Nav_Menu') ? new \Layerdrops\Agrion\Megamenu\Walker_Nav_Menu : '',
								)
							);
							?>
						</div>
					</div>
				</div>
			</div>
		</nav>
	</header>
	<?php if (get_theme_mod('header_sticky_menu') == 'yes'  && !is_admin_bar_showing()) : ?>
		<div class="stricky-header stricked-menu main-menu main-menu-three">
			<div class="sticky-header__content"></div><!-- /.sticky-header__content -->
		</div><!-- /.stricky-header -->
	<?php endif; ?>

<?php endif; ?>

<div class="mobile-nav__wrapper">
	<div class="mobile-nav__overlay mobile-nav__toggler"></div>
	<!-- /.mobile-nav__overlay -->
	<div class="mobile-nav__content">
		<span class="mobile-nav__close mobile-nav__toggler"><i class="fa fa-times"></i></span>

		<div class="logo-box">
			<a href="<?php echo esc_url(home_url('/')); ?>" aria-label="logo image">
				<img width="<?php echo esc_attr($settings['logo_dimension']['width']); ?>" height="<?php echo esc_attr($settings['logo_dimension']['height']); ?>" src="<?php echo esc_attr($settings['mobile_menu_logo']['url']); ?>" alt="<?php echo esc_attr(get_bloginfo('name')); ?>" />
			</a>
		</div>
		<!-- /.logo-box -->
		<div class="mobile-nav__container"></div>
		<?php if (!empty($settings['mobile_email']) && !empty($settings['mobile_phone'])) : ?>
			<!-- /.mobile-nav__container -->
			<ul class="mobile-nav__contact list-unstyled ml-0">
				<?php if ($settings['mobile_email']) : ?>
					<li>
						<i class="fa fa-envelope"></i>
						<a href="mailto:<?php echo esc_attr($settings['mobile_email']); ?>"><?php echo esc_html($settings['mobile_email']); ?></a>
					</li>
				<?php endif; ?>
				<?php if ($settings['mobile_phone']) : ?>
					<li>
						<i class="fa fa-phone-alt"></i>
						<a href="<?php echo esc_url($settings['mobile_url']); ?>">
							<?php echo esc_html($settings['mobile_phone']); ?>
						</a>
					</li>
				<?php endif; ?>
			</ul><!-- /.mobile-nav__contact -->
		<?php endif; ?>
		<div class="mobile-nav__top">
			<div class="mobile-nav__social">
				<?php foreach ($settings['mobile_menu_social_icons'] as $social_icon) : ?>
					<a href="<?php echo esc_url($social_icon['social_url']['url']); ?>" class="fab <?php echo esc_attr($social_icon['social_icon']['value']); ?>"></a>
				<?php endforeach; ?>
			</div><!-- /.mobile-nav__social -->
		</div><!-- /.mobile-nav__top -->

	</div>
	<!-- /.mobile-nav__content -->
</div>


<div class="search-popup">
	<div class="search-popup__overlay search-toggler"></div>
	<!-- /.search-popup__overlay -->
	<div class="search-popup__content">
		<form action="<?php echo esc_url(home_url('/')); ?>">
			<label for="search" class="sr-only"><?php echo esc_html__("search here", 'agrion-addon'); ?></label><!-- /.sr-only -->
			<input type="text" id="search" placeholder="<?php echo esc_attr__('Search Here...', 'agrion-addon') ?>" />
			<button type="submit" aria-label="search submit" class="thm-btn">
				<i class="icon-magnifying-glass"></i>
			</button>
		</form>
	</div>
	<!-- /.search-popup__content -->
</div>


<?php $agrion_back_to_top_status = get_theme_mod('scroll_to_top', 'no'); ?>
<?php if ('yes' === $agrion_back_to_top_status) : ?>
	<span data-target="html" class="scroll-to-target scroll-to-top"><i class="fa <?php echo esc_attr(get_theme_mod('scroll_to_top_icon', 'fa-angle-up')); ?>"></i></span>

<?php endif; ?>