<?php if ('layout_one' === $settings['layout_type']) : ?>
    <!--Counter One Start-->
    <section class="counter-one">
        <div class="counter-one__bg" style="
            background-image: url(<?php echo esc_url($settings['bg_image']['url']); ?>);
          "></div>
        <div class="container">
            <div class="row">
                <div class="col-xl-12">
                    <div class="counter-one__inner">
                        <ul class="list-unstyled counter-one__list ml-0">
                            <?php $i = 1;
                            foreach ($settings['funfact'] as $index => $item) : ?>
                                <li class="counter-one__single wow fadeInLeft" data-wow-delay="<?php echo esc_attr($i); ?>00ms">
                                    <div class="counter-one__icon icon-svg-large">
                                        <?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?>
                                        <div class="counter-one__shape-one">
                                            <?php agrion_elementor_rendered_image($item, 'shape_one'); ?>
                                        </div>
                                        <div class="counter-one__shape-two">
                                            <?php agrion_elementor_rendered_image($item, 'shape_two'); ?>
                                        </div>
                                    </div>
                                    <div class="counter-one__content-box count-box">
                                        <h3 class="count-text" data-stop="<?php echo esc_attr($item['count_number']); ?>" data-speed="1500">
                                            00
                                        </h3>
                                        <?php
                                        if (!empty($item['title'])) :
                                            $key_title = $this->get_repeater_setting_key('title', 'funfact', $index);
                                            $this->add_inline_editing_attributes($key_title, 'none');
                                            agrion_elementor_repeater_rendered_content($this, $item, $key_title,  'title', 'counter-one__text', 'p');
                                        endif;
                                        ?>
                                    </div>
                                </li>
                            <?php $i++;
                            endforeach; ?>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--Counter One End-->
<?php endif; ?>