<?php if ('layout_one' == $settings['layout_type']) : ?>
  <div class="footer-widget__column footer-widget__Contact">
    <?php if (!empty($settings['title'])) : ?>
      <div class="footer-widget__title-box">
        <h3 class="footer-widget__title"><?php echo esc_html($settings['title']); ?></h3>
      </div>
    <?php endif; ?>
    <?php if (is_array($settings['layout_one_items'])) : ?>
      <ul class="footer-widget__Contact-list list-unstyled ml-0">
        <?php foreach ($settings['layout_one_items'] as $key => $item) : ?>
          <li>
            <div class="icon">
              <?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?>
            </div>
            <div class="text">
              <?php
              if (!empty($item['content'])) :
                agrion_basic_rendered_content($this, $item,  'content', '', 'p');
              endif;
              ?>
            </div>
          </li>
        <?php endforeach; ?>
      </ul>
    <?php endif; ?>
    <form class="footer-widget__Contact-form mc-form" data-url="<?php echo esc_html($settings['mailchimp_url']); ?>">
      <div class="footer-widget__Contact-input-box">
        <input type="email" placeholder="<?php echo esc_attr($settings['mc_input_placeholder']); ?>" name="EMAIL" />
        <button type="submit" class="footer-widget__Contact-btn">
          <i class="icon-right-arrow"></i>
        </button>
      </div>
    </form>
    <div class="mc-form__response"></div>
  </div>
<?php endif; ?>