<?php if ('layout_one' == $settings['layout_type']) : ?>
    <div class="site-footer__bottom">
        <div class="container">
            <div class="row">
                <div class="col-xl-12">
                    <div class="site-footer__bottom-inner">
                        <p class="site-footer__bottom-text">
                            <?php echo wp_kses($settings['title'], 'agrion_allowed_tags'); ?>
                        </p>
                        <?php if (is_array($settings['social_icons'])) : ?>
                            <div class="site-footer__social">
                                <?php foreach ($settings['social_icons'] as $item) : ?>
                                    <a <?php echo esc_attr(!empty($item['social_url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($item['social_url']['url']); ?>">
                                        <?php \Elementor\Icons_Manager::render_icon($item['social_icon'], ['aria-hidden' => 'true', 'class' => ' '], 'i'); ?>
                                    </a>
                                <?php endforeach; ?>
                            </div>
                        <?php endif; ?>
                        <div class="site-footer__bottom-scroll">
                            <a href="#" data-target="html" class="scroll-to-target scroll-to-top">
                                <?php \Elementor\Icons_Manager::render_icon($settings['go_top_icon'], ['aria-hidden' => 'true', 'class' => ' '], 'i'); ?>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>