<?php if ('layout_one' == $settings['layout_type']) : ?>
    <div class="container">
        <div class="contact-details">
            <div class="row">
                <?php if (is_array($settings['layout_one_items'])) : ?>
                    <?php
                    foreach ($settings['layout_one_items'] as $key => $item) :
                        $last_child_class = '';
                        if ($key === array_key_last($settings['layout_one_items'])) {
                            $last_child_class = 'contact-details__single-last';
                        }
                    ?>
                        <div class="col-xl-3 col-lg-6 col-md-6">
                            <div class="contact-details__single <?php echo esc_attr($last_child_class); ?>">
                                <div class="contact-details__icon icon-svg">
                                    <?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?>
                                </div>
                                <div class="contact-details__text">
                                    <?php
                                    if (!empty($item['title'])) :
                                        agrion_basic_rendered_content($this, $item,  'title', '', 'p');
                                    endif;
                                    ?>
                                    <h3>
                                        <?php echo wp_kses($item['content'], 'agrion_allowed_tags'); ?>
                                    </h3>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                <?php endif; ?>
                <div class="col-xl-3 col-lg-6 col-md-6">
                    <div class="contact-details__single">
                        <div class="contact-details__social">
                            <?php foreach ($settings['social_icons'] as $item) : ?>
                                <a class="icon-svg" href="<?php echo esc_url($item['social_url']['url']); ?>">
                                    <?php \Elementor\Icons_Manager::render_icon($item['social_icon'], ['aria-hidden' => 'true', 'class' => ' '], 'i'); ?>
                                </a>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>