<?php if ('layout_one' == $settings['layout_type']) : ?>

	<!--Blog One Start-->
	<section class="blog-one">
		<div class="container">
			<?php if (!empty($settings['sec_sub_title']) || !empty($settings['sec_title'])) : ?>
				<div class="section-title text-center">
					<?php
					if (!empty($settings['sec_sub_title'])) :
						$this->add_inline_editing_attributes('sec_sub_title', 'none');
						agrion_elementor_rendered_content($this, 'sec_sub_title', 'section-title__tagline', $settings['section_sub_title_tag_layout_one']);
					endif;

					if (!empty($settings['sec_title'])) :
						$this->add_inline_editing_attributes('sec_title', 'none');
						agrion_elementor_rendered_content($this, 'sec_title', 'section-title__title', $settings['section_title_tag_layout_one']);
					endif;
					?>
					<div class="section-title__icon">
						<?php agrion_elementor_rendered_image($settings, 'sec_title_shape'); ?>
					</div>
				</div>
			<?php endif; ?>
			<div class="row">
				<?php
				$blog_post_one_query_paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
				if (!empty($settings['select_category'])) :
					$blog_post_one_query_args = array(
						'post_type' => 'post',
						'post_status' => 'publish',
						'ignore_sticky_posts' => true,
						'orderby' => 'date',
						'order'   => $settings['query_order'],
						'posts_per_page' => $settings['post_count']['size'],
						'paged'          => $blog_post_one_query_paged,
						'tax_query' => array(
							array(
								'taxonomy' => 'category',
								'field' => 'slug',
								'terms' => $settings['select_category']
							)
						)
					);
				else :
					$blog_post_one_query_args = array(
						'post_type' => 'post',
						'post_status' => 'publish',
						'ignore_sticky_posts' => true,
						'orderby' => 'date',
						'paged'          => $blog_post_one_query_paged,
						'order'   => $settings['query_order'],
						'posts_per_page' => $settings['post_count']['size']
					);

				endif;
				$blog_post_one_query = new \WP_Query($blog_post_one_query_args);
				$i = 1;
				?>
				<?php while ($blog_post_one_query->have_posts()) :
					$blog_post_one_query->the_post();

					$category = get_the_category();

				?>
					<!--Blog One Single Start-->
					<div class="col-xl-4 col-lg-4 wow fadeInUp" data-wow-delay="<?php echo esc_attr($i); ?>00ms">
						<div class="blog-one__single">
							<div class="blog-one__img">
								<?php the_post_thumbnail('agrion_blog_370X410'); ?>
								<div class="blog-one__date">
									<span><?php the_time('d'); ?></span>
									<p><?php the_time('M'); ?></p>
								</div>
							</div>
							<div class="blog-one__content">
								<ul class="blog-one__meta list-unstyled ml-0">
									<li>
										<?php agrion_posted_by(); ?>
									</li>
									<li>
										<?php agrion_comment_count(); ?>
									</li>
								</ul>
								<h3 class="blog-one__title">
									<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
								</h3>
							</div>
						</div>
					</div>
					<!--Blog One Single End-->
				<?php $i++;
				endwhile; ?>
				<?php if ('yes' == $settings['pagination_status']) : ?>
					<div class="col-lg-12">
						<div class="blog-pagination portfolio-page__btn-box justify-content-center text-center">
							<?php agrion_custom_query_pagination($blog_post_one_query_paged, $blog_post_one_query->max_num_pages); ?>
						</div><!-- /.blog-post-pagination -->
					</div><!-- /.col-lg-12 -->
				<?php endif; ?>
				<?php wp_reset_postdata(); ?>

			</div>
		</div>
	</section>
	<!--Blog One End-->
<?php endif; ?>