<?php if ('layout_five' == $settings['layout_type']) : ?>

	<!--Blog Start-->
	<section class="blog-carousel-page">
		<div class="container">
			<div class="blog-carousel thm-owl__carousel owl-theme owl-carousel carousel-dot-style" data-owl-options='<?php echo esc_attr(agrion_get_owl_options($settings)); ?>'>
				<?php
				$blog_post_one_query_paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
				if (!empty($settings['select_category'])) :
					$blog_post_one_query_args = array(
						'post_type' => 'post',
						'post_status' => 'publish',
						'ignore_sticky_posts' => true,
						'orderby' => 'date',
						'order'   => $settings['query_order'],
						'posts_per_page' => $settings['post_count']['size'],
						'paged'          => $blog_post_one_query_paged,
						'tax_query' => array(
							array(
								'taxonomy' => 'category',
								'field' => 'slug',
								'terms' => $settings['select_category']
							)
						)
					);
				else :
					$blog_post_one_query_args = array(
						'post_type' => 'post',
						'post_status' => 'publish',
						'ignore_sticky_posts' => true,
						'orderby' => 'date',
						'paged'          => $blog_post_one_query_paged,
						'order'   => $settings['query_order'],
						'posts_per_page' => $settings['post_count']['size']
					);

				endif;
				$blog_post_one_query = new \WP_Query($blog_post_one_query_args);
				$i = 1;
				?>
				<?php while ($blog_post_one_query->have_posts()) :
					$blog_post_one_query->the_post();

					$category = get_the_category();

				?>
					<!--Blog One Single Start-->
					<div class="item">
						<div class="blog-one__single">
							<div class="blog-one__img">
								<?php the_post_thumbnail('agrion_blog_370X410'); ?>
								<div class="blog-one__date">
									<span><?php the_time('d'); ?></span>
									<p><?php the_time('M'); ?></p>
								</div>
							</div>
							<div class="blog-one__content">
								<ul class="blog-one__meta list-unstyled ml-0">
									<li>
										<?php agrion_posted_by(); ?>
									</li>
									<li>
										<?php agrion_comment_count(); ?>
									</li>
								</ul>
								<h3 class="blog-one__title">
									<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
								</h3>
							</div>
						</div>
					</div>
					<!--Blog One Single End-->
				<?php $i++;
				endwhile; ?>
				<?php if ('yes' == $settings['pagination_status']) : ?>
					<div class="col-lg-12">
						<div class="blog-pagination portfolio-page__btn-box justify-content-center text-center">
							<?php agrion_custom_query_pagination($blog_post_one_query_paged, $blog_post_one_query->max_num_pages); ?>
						</div><!-- /.blog-post-pagination -->
					</div><!-- /.col-lg-12 -->
				<?php endif; ?>
				<?php wp_reset_postdata(); ?>
			</div>
		</div>
	</section>
	<!--Blog End-->

<?php endif; ?>