<?php

$this->start_controls_section(
    'layout_two_content_section',
    [
        'label' => __('Content', 'agrion-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_two'
        ]
    ]
);

$this->add_control(
    'layout_two_sec_title',
    [
        'label' => __('Section Title', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add title', 'agrion-addon'),
        'default' => __('Default Title', 'agrion-addon'),
    ]
);

agrion_elementor_heading_option($this, 'Section Title', 'h2', 'layout_two');

$this->add_control(
    'layout_two_sec_title_shape',
    [
        'label' => __('Section Title', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$this->add_control(
    'layout_two_sec_sub_title',
    [
        'label' => __('Section Sub Title', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add sub title', 'agrion-addon'),
        'default' => __('Default Sub Title', 'agrion-addon'),
    ]
);

agrion_elementor_heading_option($this, 'Section Sub Title', 'span', 'layout_two');

$layout_two_testimonial = new \Elementor\Repeater();

$layout_two_testimonial->add_control(
    'name',
    [
        'label' => __('Name', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Kevin martin', 'agrion-addon'),
        'label_block' => true
    ]
);


$layout_two_testimonial->add_control(
    'designation',
    [
        'label' => __('Designation', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('- Co-Founder', 'agrion-addon'),
        'label_block' => true
    ]
);

$layout_two_testimonial->add_control(
    'testimonial',
    [
        'label' => __('Testimonial', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'default' => __('Default Testimonial Content', 'agrion-addon'),
    ]
);


$layout_two_testimonial->add_control(
    'icon',
    [
        'label' => __('Icon', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'icon-quote',
            'library' => 'custom-icon',
        ],
    ]
);

$layout_two_testimonial->add_control(
    'image',
    [
        'label' => __('Image', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);


$this->add_control(
    'layout_two_testimonials',
    [
        'label' => __('Testimonial Items', 'agrion-addon'),
        'prevent_empty' => false,
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_two_testimonial->get_controls(),
        'title_field' => '{{{ name }}}',
    ]
);

$layout_two_features_list = new \Elementor\Repeater();

$layout_two_features_list->add_control(
    'title',
    [
        'label' => __('Title', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Add title', 'agrion-addon'),
        'default' => __('default title', 'agrion-addon'),
        'label_block' => true
    ]
);

$layout_two_features_list->add_control(
    'count_number',
    [
        'label' => __('Count Number', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Add Count Number', 'agrion-addon'),
        'default' => __('4850', 'agrion-addon'),
        'label_block' => true
    ]
);

$layout_two_features_list->add_control(
    'sign',
    [
        'label' => __('Count Sign', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Add Count Sign', 'agrion-addon'),
        'default' => __('+', 'agrion-addon'),
        'label_block' => true
    ]
);

$layout_two_features_list->add_control(
    'icon',
    [
        'label' => __('Icon', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'icon-seeds',
            'library' => 'custom-icon',
        ],
    ]
);

$this->add_control(
    'layout_two_features_list',
    [
        'label' => __('Feature Lists', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_two_features_list->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ title }}}',
    ]
);

$this->add_control(
    'layout_two_bg_image',
    [
        'label' => __('Section Background Image', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$this->end_controls_section();
