<?php

$this->start_controls_section(
    'layout_five_content_section',
    [
        'label' => __('Content', 'agrion-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_five'
        ]
    ]
);


$layout_five_testimonial = new \Elementor\Repeater();

$layout_five_testimonial->add_control(
    'name',
    [
        'label' => __('Name', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Kevin martin', 'agrion-addon'),
        'label_block' => true
    ]
);


$layout_five_testimonial->add_control(
    'designation',
    [
        'label' => __('Designation', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Co-Founder', 'agrion-addon'),
        'label_block' => true
    ]
);

$layout_five_testimonial->add_control(
    'testimonial',
    [
        'label' => __('Testimonial', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'default' => __('Default Testimonial Content', 'agrion-addon'),
    ]
);


$layout_five_testimonial->add_control(
    'icon',
    [
        'label' => __('Icon', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'icon-quote',
            'library' => 'custom-icon',
        ],
    ]
);

$layout_five_testimonial->add_control(
    'image',
    [
        'label' => __('Image', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);


$this->add_control(
    'layout_five_testimonials',
    [
        'label' => __('Testimonial Items', 'agrion-addon'),
        'prevent_empty' => false,
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_five_testimonial->get_controls(),
        'title_field' => '{{{ name }}}',
    ]
);

$this->end_controls_section();
