<?php

$this->start_controls_section(
    'layout_two_content',
    [
        'label' => __('Content', 'agrion-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_two'
        ]
    ]
);


$layout_two_team = new \Elementor\Repeater();

$layout_two_team->add_control(
    'name',
    [
        'label' => __('Name', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Aleesha Brown', 'agrion-addon'),
        'label_block' => true,
    ]
);

$layout_two_team->add_control(
    'url',
    [
        'label' => __('Url', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('#', 'agrion-addon'),
        'show_external' => false,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => true,
        ],
        'show_label' => false,
    ]
);

$layout_two_team->add_control(
    'designation',
    [
        'label' => __('Designation', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'label_block' => true,
        'default' => __('Senior Farmer', 'agrion-addon'),
    ]
);


$layout_two_team->add_control(
    'social_network',
    [
        'label' => __('Social NetWork', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::CODE,
        'label_block' => true,
        'default' => wp_kses('<li><a href="#"><i class="fab fa-facebook-f"></i><span class="layout_two_team-one__social-name">Facebook</span></a></li>', 'agrion_allowed_tags')
    ]
);

$layout_two_team->add_control(
    'image',
    [
        'label' => __('Image', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);

$layout_two_team->add_control(
    'shape',
    [
        'label' => __('shape', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$this->add_control(
    'layout_two_team_items',
    [
        'label' => __('Team', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_two_team->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ name }}}',
    ]
);

$this->end_controls_section();
