<?php

$this->start_controls_section(
    'layout_two_content_section',
    [
        'label' => __('Content', 'agrion-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_two'
        ]
    ]
);

$this->add_control(
    'layout_two_title',
    [
        'label' => __('Add Title', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'default' => __('Default Title', 'agrion-addon')
    ]
);

agrion_elementor_heading_option($this, 'Title', 'h3', 'layout_two');

$this->add_control(
    'layout_two_call_text',
    [
        'label' => __('Call Text', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Call Anytime', 'agrion-addon'),
        'label_block' => true
    ]
);

$this->add_control(
    'layout_two_call_number',
    [
        'label' => __('Call Number', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('+ 1- (246) 333-0088', 'agrion-addon')
    ]
);

$this->add_control(
    'layout_two_call_url',
    [
        'label' => __('Call Url', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::URL,
        'show_external' => false,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => true,
        ],
        'show_label' => false,
    ]
);

$this->add_control(
    'layout_two_icon',
    [
        'label' => __('Icon', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'icon-phone-ringing',
            'library' => 'custom-icon',
        ],
    ]
);

$this->add_control(
    'layout_two_background_image',
    [
        'label' => __('Background Image', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);


$this->end_controls_section();
