<?php

$this->start_controls_section(
    'layout_three_content_section',
    [
        'label' => __('Content', 'agrion-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_three'
        ]
    ]
);

$layout_three_item = new \Elementor\Repeater();

$layout_three_item->add_control(
    'title',
    [
        'label' => __('Title', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Date', 'agrion-addon'),
        'label_block' => true,
    ]
);

$layout_three_item->add_control(
    'info',
    [
        'label' => __('Info', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'label_block' => true,
        'default' => __('30 July, 2022', 'agrion-addon')
    ]
);


$this->add_control(
    'layout_three_items',
    [
        'label' => __('Info', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_three_item->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ title }}}',
    ]
);


$layout_three_social_icons = new \Elementor\Repeater();

$layout_three_social_icons->add_control(
    'social_icon',
    [
        'label' => __('Select Icon', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'fab fa-facebook-f',
            'library' => 'brand',
        ],
        'label_block' => true,
    ]
);

$layout_three_social_icons->add_control(
    'social_url',
    [
        'label' => __('Add Url', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('#', 'agrion-addon'),
        'show_external' => false,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => false,
        ],
        'show_label' => false,
    ]
);

$this->add_control(
    'layout_three_social_icons',
    [
        'label' => __('Social Icons', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'prevent_empty' => false,
        'fields' => $layout_three_social_icons->get_controls(),
        'default' => [
            [
                'social_url' => [
                    'url' => '#',
                    'is_external' => false,
                    'nofollow' => false,
                ],
            ],
        ],
    ]
);

$this->add_control(
    'layout_three_bg_image',
    [
        'label' => __('Background Image', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$this->end_controls_section();
